/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.ServerFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.DockerCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.DockerContainerEnvironment;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.IdGenerator;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.collect.ImmutableCollection;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.net.HostAndPort;
import org.apache.beam.sdk.options.ManualDockerEnvironmentOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ByteString;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ProtocolMessageEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerEnvironmentFactory
implements EnvironmentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DockerEnvironmentFactory.class);
    private final DockerCommand docker;
    private final GrpcFnServer<FnApiControlClientPoolService> controlServiceServer;
    private final GrpcFnServer<GrpcLoggingService> loggingServiceServer;
    private final GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer;
    private final GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer;
    private final IdGenerator idGenerator;
    private final ControlClientPool.Source clientSource;
    private final boolean retainDockerContainer;

    static DockerEnvironmentFactory forServicesWithDocker(DockerCommand docker, GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, ControlClientPool.Source clientSource, IdGenerator idGenerator, boolean retainDockerContainer) {
        return new DockerEnvironmentFactory(docker, controlServiceServer, loggingServiceServer, retrievalServiceServer, provisioningServiceServer, idGenerator, clientSource, retainDockerContainer);
    }

    private DockerEnvironmentFactory(DockerCommand docker, GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, IdGenerator idGenerator, ControlClientPool.Source clientSource, boolean retainDockerContainer) {
        this.docker = docker;
        this.controlServiceServer = controlServiceServer;
        this.loggingServiceServer = loggingServiceServer;
        this.retrievalServiceServer = retrievalServiceServer;
        this.provisioningServiceServer = provisioningServiceServer;
        this.idGenerator = idGenerator;
        this.clientSource = clientSource;
        this.retainDockerContainer = retainDockerContainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RemoteEnvironment createEnvironment(RunnerApi.Environment environment) throws Exception {
        Preconditions.checkState(environment.getUrn().equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)), "The passed environment does not contain a DockerPayload.");
        RunnerApi.DockerPayload dockerPayload = RunnerApi.DockerPayload.parseFrom((ByteString)environment.getPayload());
        String workerId = this.idGenerator.getId();
        String containerImage = dockerPayload.getContainerImage();
        String loggingEndpoint = this.loggingServiceServer.getApiServiceDescriptor().getUrl();
        String artifactEndpoint = this.retrievalServiceServer.getApiServiceDescriptor().getUrl();
        String provisionEndpoint = this.provisioningServiceServer.getApiServiceDescriptor().getUrl();
        String controlEndpoint = this.controlServiceServer.getApiServiceDescriptor().getUrl();
        ImmutableCollection.ArrayBasedBuilder dockerArgsBuilder = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.gcsCredentialArgs())).add("--network=host")).add("--env=DOCKER_MAC_CONTAINER=" + System.getenv("DOCKER_MAC_CONTAINER"));
        if (!this.retainDockerContainer) {
            ((ImmutableList.Builder)dockerArgsBuilder).add("--rm");
        }
        ImmutableList<String> args = ImmutableList.of(String.format("--id=%s", workerId), String.format("--logging_endpoint=%s", loggingEndpoint), String.format("--artifact_endpoint=%s", artifactEndpoint), String.format("--provision_endpoint=%s", provisionEndpoint), String.format("--control_endpoint=%s", controlEndpoint));
        LOG.debug("Creating Docker Container with ID {}", (Object)workerId);
        String containerId = null;
        InstructionRequestHandler instructionHandler = null;
        try {
            containerId = this.docker.runImage(containerImage, (List<String>)((Object)((ImmutableList.Builder)dockerArgsBuilder).build()), args);
            LOG.debug("Created Docker Container with Container ID {}", (Object)containerId);
            while (instructionHandler == null) {
                try {
                    instructionHandler = this.clientSource.take(workerId, Duration.ofMinutes(2L));
                }
                catch (TimeoutException timeoutEx) {
                    LOG.info("Still waiting for startup of environment {} for worker id {}", (Object)dockerPayload.getContainerImage(), (Object)workerId);
                }
                catch (InterruptedException interruptEx) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(interruptEx);
                    return DockerContainerEnvironment.create(this.docker, environment, containerId, instructionHandler);
                }
            }
        }
        catch (Exception e) {
            if (containerId == null) throw e;
            try {
                this.docker.killContainer(containerId);
                throw e;
            }
            catch (Exception dockerException) {
                e.addSuppressed(dockerException);
            }
            throw e;
        }
    }

    private List<String> gcsCredentialArgs() {
        String dockerGcloudConfig = "/root/.config/gcloud";
        String localGcloudConfig = MoreObjects.firstNonNull(System.getenv("CLOUDSDK_CONFIG"), Paths.get(System.getProperty("user.home"), ".config", "gcloud").toString());
        if (Files.exists(Paths.get(localGcloudConfig, new String[0]), new LinkOption[0])) {
            return ImmutableList.of("--mount", String.format("type=bind,src=%s,dst=%s", localGcloudConfig, dockerGcloudConfig));
        }
        return ImmutableList.of();
    }

    public static class Provider
    implements EnvironmentFactory.Provider {
        private final boolean retainDockerContainer;

        public Provider(PipelineOptions options) {
            this.retainDockerContainer = ((ManualDockerEnvironmentOptions)options.as(ManualDockerEnvironmentOptions.class)).getRetainDockerContainers();
        }

        @Override
        public EnvironmentFactory createEnvironmentFactory(GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, ControlClientPool clientPool, IdGenerator idGenerator) {
            return DockerEnvironmentFactory.forServicesWithDocker(DockerCommand.getDefault(), controlServiceServer, loggingServiceServer, retrievalServiceServer, provisioningServiceServer, clientPool.getSource(), idGenerator, this.retainDockerContainer);
        }

        @Override
        public ServerFactory getServerFactory() {
            switch (Provider.getPlatform()) {
                case LINUX: {
                    return ServerFactory.createDefault();
                }
                case MAC: {
                    return DockerOnMac.getServerFactory();
                }
            }
            LOG.warn("Unknown Docker platform. Falling back to default server factory");
            return ServerFactory.createDefault();
        }

        private static Platform getPlatform() {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("mac") || DockerOnMac.RUNNING_INSIDE_DOCKER_ON_MAC) {
                return Platform.MAC;
            }
            if (osName.startsWith("linux")) {
                return Platform.LINUX;
            }
            return Platform.OTHER;
        }

        private static enum Platform {
            MAC,
            LINUX,
            OTHER;

        }
    }

    private static class DockerOnMac {
        private static final String DOCKER_FOR_MAC_HOST = "host.docker.internal";
        private static final boolean RUNNING_INSIDE_DOCKER_ON_MAC = "1".equals(System.getenv("DOCKER_MAC_CONTAINER"));
        private static final int MAC_PORT_START = 8100;
        private static final int MAC_PORT_END = 8200;
        private static final AtomicInteger MAC_PORT = new AtomicInteger(8100);

        private DockerOnMac() {
        }

        private static ServerFactory getServerFactory() {
            ServerFactory.UrlFactory dockerUrlFactory = (host, port) -> HostAndPort.fromParts(DOCKER_FOR_MAC_HOST, port).toString();
            if (RUNNING_INSIDE_DOCKER_ON_MAC) {
                return ServerFactory.createWithUrlFactoryAndPortSupplier(dockerUrlFactory, () -> MAC_PORT.getAndUpdate(val -> val == 8200 ? 8100 : val + 1));
            }
            return ServerFactory.createWithUrlFactory(dockerUrlFactory);
        }
    }
}

