/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.beam.runners.direct.AbstractModelEnforcement;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.ModelEnforcement;
import org.apache.beam.runners.direct.ModelEnforcementFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.IllegalMutationException;
import org.apache.beam.sdk.util.MutationDetector;
import org.apache.beam.sdk.util.MutationDetectors;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;

class ImmutabilityEnforcementFactory
implements ModelEnforcementFactory {
    ImmutabilityEnforcementFactory() {
    }

    public static ModelEnforcementFactory create() {
        return new ImmutabilityEnforcementFactory();
    }

    @Override
    public <T> ModelEnforcement<T> forBundle(CommittedBundle<T> input, AppliedPTransform<?, ?, ?> consumer) {
        return new ImmutabilityCheckingEnforcement(input, consumer);
    }

    private static class ImmutabilityCheckingEnforcement<T>
    extends AbstractModelEnforcement<T> {
        private final AppliedPTransform<?, ?, ?> transform;
        private final Map<WindowedValue<T>, MutationDetector> mutationElements;
        private final Coder<T> coder;

        private ImmutabilityCheckingEnforcement(CommittedBundle<T> input, AppliedPTransform<?, ?, ?> transform) {
            this.transform = transform;
            this.coder = input.getPCollection().getCoder();
            this.mutationElements = new IdentityHashMap<WindowedValue<T>, MutationDetector>();
        }

        @Override
        public void beforeElement(WindowedValue<T> element) {
            try {
                this.mutationElements.put(element, MutationDetectors.forValueWithCoder((Object)element.getValue(), this.coder));
            }
            catch (CoderException e) {
                throw UserCodeException.wrap((Throwable)e);
            }
        }

        @Override
        public void afterElement(WindowedValue<T> element) {
            this.verifyUnmodified(this.mutationElements.get(element));
        }

        @Override
        public void afterFinish(CommittedBundle<T> input, TransformResult<T> result, Iterable<? extends CommittedBundle<?>> outputs) {
            for (MutationDetector detector : this.mutationElements.values()) {
                this.verifyUnmodified(detector);
            }
        }

        private void verifyUnmodified(MutationDetector detector) {
            try {
                detector.verifyUnmodified();
            }
            catch (IllegalMutationException e) {
                throw new IllegalMutationException(String.format("PTransform %s illegaly mutated value %s of class %s. Input values must not be mutated in any way.", this.transform.getFullName(), e.getSavedValue(), e.getSavedValue().getClass()), e.getSavedValue(), e.getNewValue());
            }
        }
    }
}

