/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.io.IOException;
import java.util.Map;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.CreatePCollectionViewTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformReplacements;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.ReplacementOutputs;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

class ViewOverrideFactory<ElemT, ViewT>
implements PTransformOverrideFactory<PCollection<ElemT>, PCollection<ElemT>, PTransform<PCollection<ElemT>, PCollection<ElemT>>> {
    public static final String DIRECT_WRITE_VIEW_URN = "urn:beam:directrunner:transforms:write_view:v1";

    ViewOverrideFactory() {
    }

    public PTransformOverrideFactory.PTransformReplacement<PCollection<ElemT>, PCollection<ElemT>> getReplacementTransform(AppliedPTransform<PCollection<ElemT>, PCollection<ElemT>, PTransform<PCollection<ElemT>, PCollection<ElemT>>> transform) {
        PCollectionView view;
        try {
            view = CreatePCollectionViewTranslation.getView(transform);
        }
        catch (IOException exc) {
            throw new RuntimeException(String.format("Could not extract %s from transform %s", PCollectionView.class.getSimpleName(), transform), exc);
        }
        return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(transform), new GroupAndWriteView(view));
    }

    public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<ElemT> newOutput) {
        return ReplacementOutputs.singleton(outputs, newOutput);
    }

    static final class WriteView<ElemT, ViewT>
    extends PTransform<PCollection<Iterable<ElemT>>, PCollection<Iterable<ElemT>>> {
        private final PCollectionView<ViewT> view;

        WriteView(PCollectionView<ViewT> view) {
            this.view = view;
        }

        public PCollection<Iterable<ElemT>> expand(PCollection<Iterable<ElemT>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), (Coder)input.getCoder());
        }

        public PCollectionView<ViewT> getView() {
            return this.view;
        }
    }

    static class GroupAndWriteView<ElemT, ViewT>
    extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
        private final PCollectionView<ViewT> view;

        private GroupAndWriteView(PCollectionView<ViewT> view) {
            this.view = view;
        }

        public PCollection<ElemT> expand(PCollection<ElemT> input) {
            ((PCollection)((PCollection)((PCollection)input.apply((PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), (Coder)input.getCoder())).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply(new WriteView(this.view));
            return input;
        }
    }
}

