/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.GrpcContextHeaderAccessorProvider;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.ServerFactory;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.ServerInterceptor;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.ServerInterceptors;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.inprocess.InProcessServerBuilder;

public class InProcessServerFactory
extends ServerFactory {
    private static final AtomicInteger serviceNameUniqifier = new AtomicInteger();

    public static InProcessServerFactory create() {
        return new InProcessServerFactory();
    }

    private InProcessServerFactory() {
    }

    @Override
    public Server allocatePortAndCreate(BindableService service, Endpoints.ApiServiceDescriptor.Builder builder) throws IOException {
        String name = String.format("InProcessServer_%s", serviceNameUniqifier.getAndIncrement());
        builder.setUrl(name);
        return ((InProcessServerBuilder)InProcessServerBuilder.forName((String)name).addService(service)).build().start();
    }

    @Override
    public Server create(BindableService service, Endpoints.ApiServiceDescriptor serviceDescriptor) throws IOException {
        return ((InProcessServerBuilder)InProcessServerBuilder.forName((String)serviceDescriptor.getUrl()).addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{GrpcContextHeaderAccessorProvider.interceptor()}))).build().start();
    }
}

