/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.channel;

import java.net.SocketAddress;
import java.util.List;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.channel.SocketAddressFactory;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.ClientInterceptor;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.ManagedChannelBuilder;
import org.apache.beam.vendor.grpc.v1_13_1.io.grpc.netty.NettyChannelBuilder;
import org.apache.beam.vendor.grpc.v1_13_1.io.netty.channel.EventLoopGroup;
import org.apache.beam.vendor.grpc.v1_13_1.io.netty.channel.epoll.EpollDomainSocketChannel;
import org.apache.beam.vendor.grpc.v1_13_1.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.beam.vendor.grpc.v1_13_1.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.beam.vendor.grpc.v1_13_1.io.netty.channel.unix.DomainSocketAddress;

public abstract class ManagedChannelFactory {
    public static ManagedChannelFactory createDefault() {
        return new Default();
    }

    public static ManagedChannelFactory createEpoll() {
        org.apache.beam.vendor.grpc.v1_13_1.io.netty.channel.epoll.Epoll.ensureAvailability();
        return new Epoll();
    }

    public ManagedChannel forDescriptor(Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
        return this.builderFor(apiServiceDescriptor).build();
    }

    protected abstract ManagedChannelBuilder<?> builderFor(Endpoints.ApiServiceDescriptor var1);

    public ManagedChannelFactory withInterceptors(List<ClientInterceptor> interceptors) {
        return new InterceptedManagedChannelFactory(this, interceptors);
    }

    private static class InterceptedManagedChannelFactory
    extends ManagedChannelFactory {
        private final ManagedChannelFactory channelFactory;
        private final List<ClientInterceptor> interceptors;

        private InterceptedManagedChannelFactory(ManagedChannelFactory managedChannelFactory, List<ClientInterceptor> interceptors) {
            this.channelFactory = managedChannelFactory;
            this.interceptors = interceptors;
        }

        @Override
        public ManagedChannel forDescriptor(Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
            return this.builderFor(apiServiceDescriptor).intercept(this.interceptors).build();
        }

        @Override
        protected ManagedChannelBuilder<?> builderFor(Endpoints.ApiServiceDescriptor descriptor) {
            return this.channelFactory.builderFor(descriptor);
        }

        @Override
        public ManagedChannelFactory withInterceptors(List<ClientInterceptor> interceptors) {
            return new InterceptedManagedChannelFactory(this.channelFactory, interceptors);
        }
    }

    private static class Default
    extends ManagedChannelFactory {
        private Default() {
        }

        @Override
        public ManagedChannelBuilder<?> builderFor(Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
            return ManagedChannelBuilder.forTarget((String)apiServiceDescriptor.getUrl()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE);
        }
    }

    private static class Epoll
    extends ManagedChannelFactory {
        private Epoll() {
        }

        @Override
        public ManagedChannelBuilder<?> builderFor(Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
            SocketAddress address = SocketAddressFactory.createFrom(apiServiceDescriptor.getUrl());
            return NettyChannelBuilder.forAddress((SocketAddress)address).channelType(address instanceof DomainSocketAddress ? EpollDomainSocketChannel.class : EpollSocketChannel.class).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE);
        }
    }
}

