/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable.artifact;

import java.io.File;
import java.io.IOException;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;

class LocalArtifactStagingLocation {
    private final File rootDirectory;
    private final File artifactsDirectory;

    public static LocalArtifactStagingLocation createAt(File rootDirectory) {
        return new LocalArtifactStagingLocation(rootDirectory).createDirectories();
    }

    public static LocalArtifactStagingLocation forExistingDirectory(File rootDirectory) {
        return new LocalArtifactStagingLocation(rootDirectory).verifyExistence();
    }

    private LocalArtifactStagingLocation(File base) {
        this.rootDirectory = base;
        this.artifactsDirectory = new File(base, "artifacts");
    }

    private LocalArtifactStagingLocation createDirectories() {
        if (!((this.rootDirectory.exists() && this.rootDirectory.isDirectory() || this.rootDirectory.mkdirs()) && this.rootDirectory.canWrite())) {
            throw new IllegalStateException(String.format("Could not create staging directory structure at root %s", this.rootDirectory));
        }
        Preconditions.checkState((this.artifactsDirectory.exists() && this.artifactsDirectory.isDirectory() || this.artifactsDirectory.mkdir()) && this.artifactsDirectory.canWrite(), "Could not create artifact staging directory at %s", (Object)this.artifactsDirectory);
        return this;
    }

    private LocalArtifactStagingLocation verifyExistence() {
        Preconditions.checkArgument(this.rootDirectory.exists(), "Nonexistent staging location root %s", (Object)this.rootDirectory);
        Preconditions.checkArgument(this.rootDirectory.isDirectory(), "Staging location %s is not a directory", (Object)this.rootDirectory);
        Preconditions.checkArgument(this.artifactsDirectory.exists(), "Nonexistent artifact directory %s", (Object)this.artifactsDirectory);
        Preconditions.checkArgument(this.artifactsDirectory.isDirectory(), "Artifact location %s is not a directory", (Object)this.artifactsDirectory);
        Preconditions.checkArgument(this.getManifestFile().exists(), "No Manifest in existing location %s", (Object)this.rootDirectory);
        return this;
    }

    public File getArtifactFile(String artifactName) {
        return new File(this.artifactsDirectory, artifactName);
    }

    public File getManifestFile() {
        return new File(this.rootDirectory, "MANIFEST");
    }

    public String getRootPath() {
        try {
            return this.rootDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

