/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.runners.flink.translation.utils.CountingPipelineVisitor;
import org.apache.beam.runners.flink.translation.utils.LookupPipelineVisitor;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;

class FlinkBatchTranslationContext {
    private final Map<PValue, DataSet<?>> dataSets;
    private final Map<PCollectionView<?>, DataSet<?>> broadcastDataSets;
    private final Map<PValue, DataSet<?>> danglingDataSets;
    private final ExecutionEnvironment env;
    private final PipelineOptions options;
    private AppliedPTransform<?, ?, ?> currentTransform;
    private final CountingPipelineVisitor countingPipelineVisitor = new CountingPipelineVisitor();
    private final LookupPipelineVisitor lookupPipelineVisitor = new LookupPipelineVisitor();

    FlinkBatchTranslationContext(ExecutionEnvironment env, PipelineOptions options) {
        this.env = env;
        this.options = options;
        this.dataSets = new HashMap();
        this.broadcastDataSets = new HashMap();
        this.danglingDataSets = new HashMap();
    }

    void init(Pipeline pipeline) {
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)this.countingPipelineVisitor);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)this.lookupPipelineVisitor);
    }

    Map<PValue, DataSet<?>> getDanglingDataSets() {
        return this.danglingDataSets;
    }

    ExecutionEnvironment getExecutionEnvironment() {
        return this.env;
    }

    public PipelineOptions getPipelineOptions() {
        return this.options;
    }

    <T> DataSet<WindowedValue<T>> getInputDataSet(PValue value) {
        this.danglingDataSets.remove(value);
        return this.dataSets.get(value);
    }

    <T> void setOutputDataSet(PValue value, DataSet<WindowedValue<T>> set) {
        if (!this.dataSets.containsKey(value)) {
            this.dataSets.put(value, set);
            this.danglingDataSets.put(value, set);
        }
    }

    void setCurrentTransform(AppliedPTransform<?, ?, ?> currentTransform) {
        this.currentTransform = currentTransform;
    }

    AppliedPTransform<?, ?, ?> getCurrentTransform() {
        return this.currentTransform;
    }

    Map<TupleTag<?>, Coder<?>> getOutputCoders(PTransform<?, ?> transform) {
        return this.lookupPipelineVisitor.getOutputCoders(transform);
    }

    <T> DataSet<T> getSideInputDataSet(PCollectionView<?> value) {
        return this.broadcastDataSets.get(value);
    }

    <ViewT, ElemT> void setSideInputDataSet(PCollectionView<ViewT> value, DataSet<WindowedValue<ElemT>> set) {
        if (!this.broadcastDataSets.containsKey(value)) {
            this.broadcastDataSets.put(value, set);
        }
    }

    <T> TypeInformation<WindowedValue<T>> getTypeInfo(PCollection<T> collection) {
        return this.getTypeInfo(collection.getCoder(), collection.getWindowingStrategy());
    }

    <T> TypeInformation<WindowedValue<T>> getTypeInfo(Coder<T> coder, WindowingStrategy<?, ?> windowingStrategy) {
        WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.getFullCoder(coder, (Coder)windowingStrategy.getWindowFn().windowCoder());
        return new CoderTypeInformation<WindowedValue<T>>(windowedValueCoder, this.options);
    }

    Map<TupleTag<?>, PCollection<?>> getInputs(PTransform<?, ?> transform) {
        return this.lookupPipelineVisitor.getInputs(transform);
    }

    <T extends PValue> T getInput(PTransform<T, ?> transform) {
        return this.lookupPipelineVisitor.getInput(transform);
    }

    Map<TupleTag<?>, PCollection<?>> getOutputs(PTransform<?, ?> transform) {
        return this.lookupPipelineVisitor.getOutputs(transform);
    }

    <T extends PValue> T getOutput(PTransform<?, T> transform) {
        return this.lookupPipelineVisitor.getOutput(transform);
    }

    int getNumConsumers(PValue value) {
        return this.countingPipelineVisitor.getNumConsumers(value);
    }
}

