/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElement;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingElementsHandler;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.state.ListState;

public class NonKeyedBufferingElementsHandler<T>
implements BufferingElementsHandler {
    private final ListState<BufferedElement> elementState;

    static <T> NonKeyedBufferingElementsHandler<T> create(ListState<BufferedElement> elementState) {
        return new NonKeyedBufferingElementsHandler<T>(elementState);
    }

    private NonKeyedBufferingElementsHandler(ListState<BufferedElement> elementState) {
        this.elementState = (ListState)Preconditions.checkNotNull(elementState);
    }

    @Override
    public Stream<BufferedElement> getElements() {
        try {
            return StreamSupport.stream(((Iterable)this.elementState.get()).spliterator(), false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve buffered element from state backend.", e);
        }
    }

    @Override
    public void buffer(BufferedElement element) {
        try {
            this.elementState.add((Object)element);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to buffer element in state backend.", e);
        }
    }

    @Override
    public void clear() {
        this.elementState.clear();
    }
}

