/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class CoderTypeInformation<@UnknownKeyFor T>
extends TypeInformation<T>
implements AtomicType<T> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions;

    public CoderTypeInformation(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this(coder, new SerializablePipelineOptions(pipelineOptions));
    }

    public CoderTypeInformation(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions) {
        Preconditions.checkNotNull(coder);
        Preconditions.checkNotNull((Object)pipelineOptions);
        this.coder = coder;
        this.pipelineOptions = pipelineOptions;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getCoder() {
        return this.coder;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isBasicType() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isTupleType() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized int getArity() {
        return 1;
    }

    public @UnknownKeyFor @NonNull @Initialized Class<T> getTypeClass() {
        return this.coder.getEncodedTypeDescriptor().getRawType();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isKeyType() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeSerializer<T> createSerializer(@UnknownKeyFor @NonNull @Initialized ExecutionConfig config) {
        return new CoderTypeSerializer<T>(this.coder, this.pipelineOptions);
    }

    public @UnknownKeyFor @NonNull @Initialized int getTotalFields() {
        return 2;
    }

    public @UnknownKeyFor @NonNull @Initialized CoderTypeInformation<T> withPipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        return new CoderTypeInformation<T>(this.getCoder(), pipelineOptions);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoderTypeInformation that = (CoderTypeInformation)((Object)o);
        return this.coder.equals(that.coder);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.coder.hashCode();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean canEqual(@UnknownKeyFor @NonNull @Initialized Object obj) {
        return obj instanceof CoderTypeInformation;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "CoderTypeInformation{coder=" + this.coder + '}';
    }

    public @UnknownKeyFor @NonNull @Initialized TypeComparator<T> createComparator(@UnknownKeyFor @NonNull @Initialized boolean sortOrderAscending, @UnknownKeyFor @NonNull @Initialized ExecutionConfig executionConfig) {
        throw new UnsupportedOperationException("Non-encoded values cannot be compared directly.");
    }
}

