/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.List;
import org.apache.beam.runners.flink.FlinkStateBackendFactory;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;

public interface FlinkPipelineOptions
extends PipelineOptions,
ApplicationNameOptions,
StreamingOptions {
    public static final String AUTO = "[auto]";
    public static final String PIPELINED = "PIPELINED";
    public static final String EXACTLY_ONCE = "EXACTLY_ONCE";

    @Description(value="Jar-Files to send to all workers and put on the classpath. The default value is all files from the classpath.")
    public List<String> getFilesToStage();

    public void setFilesToStage(List<String> var1);

    @Description(value="Address of the Flink Master where the Pipeline should be executed. Can either be of the form \"host:port\" or one of the special values [local], [collection] or [auto].")
    @Default.String(value="[auto]")
    public String getFlinkMaster();

    public void setFlinkMaster(String var1);

    @Description(value="The degree of parallelism to be used when distributing operations onto workers. If the parallelism is not set, the configured Flink default is used, or 1 if none can be found.")
    @Default.Integer(value=-1)
    public Integer getParallelism();

    public void setParallelism(Integer var1);

    @Description(value="The pipeline wide maximum degree of parallelism to be used. The maximum parallelism specifies the upper limit for dynamic scaling and the number of key groups used for partitioned state.")
    @Default.Integer(value=-1)
    public Integer getMaxParallelism();

    public void setMaxParallelism(Integer var1);

    @Description(value="The interval in milliseconds at which to trigger checkpoints of the running pipeline. Default: No checkpointing.")
    @Default.Long(value=-1L)
    public Long getCheckpointingInterval();

    public void setCheckpointingInterval(Long var1);

    @Description(value="The checkpointing mode that defines consistency guarantee.")
    @Default.String(value="EXACTLY_ONCE")
    public String getCheckpointingMode();

    public void setCheckpointingMode(String var1);

    @Description(value="The maximum time in milliseconds that a checkpoint may take before being discarded.")
    @Default.Long(value=-1L)
    public Long getCheckpointTimeoutMillis();

    public void setCheckpointTimeoutMillis(Long var1);

    @Description(value="The minimal pause in milliseconds before the next checkpoint is triggered.")
    @Default.Long(value=-1L)
    public Long getMinPauseBetweenCheckpoints();

    public void setMinPauseBetweenCheckpoints(Long var1);

    @Description(value="Sets the expected behaviour for tasks in case that they encounter an error in their checkpointing procedure. If this is set to true, the task will fail on checkpointing error. If this is set to false, the task will only decline a the checkpoint and continue running. ")
    @Default.Boolean(value=true)
    public Boolean getFailOnCheckpointingErrors();

    public void setFailOnCheckpointingErrors(Boolean var1);

    @Description(value="Sets the number of times that failed tasks are re-executed. A value of zero effectively disables fault tolerance. A value of -1 indicates that the system default value (as defined in the configuration) should be used.")
    @Default.Integer(value=-1)
    public Integer getNumberOfExecutionRetries();

    public void setNumberOfExecutionRetries(Integer var1);

    @Description(value="Sets the delay in milliseconds between executions. A value of {@code -1} indicates that the default value should be used.")
    @Default.Long(value=-1L)
    public Long getExecutionRetryDelay();

    public void setExecutionRetryDelay(Long var1);

    @Description(value="Sets the behavior of reusing objects.")
    @Default.Boolean(value=false)
    public Boolean getObjectReuse();

    public void setObjectReuse(Boolean var1);

    @Description(value="Sets the state backend factory to use in streaming mode. Defaults to the flink cluster's state.backend configuration.")
    public Class<? extends FlinkStateBackendFactory> getStateBackendFactory();

    public void setStateBackendFactory(Class<? extends FlinkStateBackendFactory> var1);

    @Description(value="Enable/disable Beam metrics in Flink Runner")
    @Default.Boolean(value=true)
    public Boolean getEnableMetrics();

    public void setEnableMetrics(Boolean var1);

    @Description(value="Enables or disables externalized checkpoints. Works in conjunction with CheckpointingInterval")
    @Default.Boolean(value=false)
    public Boolean isExternalizedCheckpointsEnabled();

    public void setExternalizedCheckpointsEnabled(Boolean var1);

    @Description(value="Sets the behavior of externalized checkpoints on cancellation.")
    @Default.Boolean(value=false)
    public Boolean getRetainExternalizedCheckpointsOnCancellation();

    public void setRetainExternalizedCheckpointsOnCancellation(Boolean var1);

    @Description(value="The maximum number of elements in a bundle.")
    @Default.Long(value=1000L)
    public Long getMaxBundleSize();

    public void setMaxBundleSize(Long var1);

    @Description(value="The maximum time to wait before finalising a bundle (in milliseconds).")
    @Default.Long(value=1000L)
    public Long getMaxBundleTimeMills();

    public void setMaxBundleTimeMills(Long var1);

    @Description(value="If set, shutdown sources when their watermark reaches +Inf.")
    @Default.Boolean(value=false)
    public Boolean isShutdownSourcesOnFinalWatermark();

    public void setShutdownSourcesOnFinalWatermark(Boolean var1);

    @Description(value="Interval in milliseconds for sending latency tracking marks from the sources to the sinks. Interval value <= 0 disables the feature.")
    @Default.Long(value=0L)
    public Long getLatencyTrackingInterval();

    public void setLatencyTrackingInterval(Long var1);

    @Description(value="The interval in milliseconds for automatic watermark emission.")
    public Long getAutoWatermarkInterval();

    public void setAutoWatermarkInterval(Long var1);

    @Description(value="Flink mode for data exchange of batch pipelines. Reference {@link org.apache.flink.api.common.ExecutionMode}. Set this to BATCH_FORCED if pipelines get blocked, see https://issues.apache.org/jira/browse/FLINK-10672")
    @Default.String(value="PIPELINED")
    public String getExecutionModeForBatch();

    public void setExecutionModeForBatch(String var1);

    @Description(value="Savepoint restore path. If specified, restores the streaming pipeline from the provided path.")
    public String getSavepointPath();

    public void setSavepointPath(String var1);

    @Description(value="Flag indicating whether non restored state is allowed if the savepoint contains state for an operator that is no longer part of the pipeline.")
    @Default.Boolean(value=false)
    public Boolean getAllowNonRestoredState();

    public void setAllowNonRestoredState(Boolean var1);

    @Description(value="Flag indicating whether auto-balance sharding for WriteFiles transform should be enabled. This might prove useful in streaming use-case, where pipeline needs to write quite many events into files, typically divided into N shards. Default behavior on Flink would be, that some workers will receive more shards to take care of than others. This cause workers to go out of balance in terms of processing backlog and memory usage. Enabling this feature will make shards to be spread evenly among available workers in improve throughput and memory usage stability.")
    @Default.Boolean(value=false)
    public Boolean isAutoBalanceWriteFilesShardingEnabled();

    public void setAutoBalanceWriteFilesShardingEnabled(Boolean var1);
}

