/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.Map;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.runners.flink.FlinkDetachedRunnerResult;
import org.apache.beam.runners.flink.FlinkRunnerResult;
import org.apache.beam.runners.fnexecution.jobsubmission.PortablePipelineResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkPortableRunnerResult
extends FlinkRunnerResult
implements PortablePipelineResult {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkPortableRunnerResult.class);

    FlinkPortableRunnerResult(Map<String, Object> accumulators, long runtime) {
        super(accumulators, runtime);
    }

    public JobApi.MetricResults portableMetrics() throws UnsupportedOperationException {
        Iterable monitoringInfos = this.getMetricsContainerStepMap().getMonitoringInfos();
        return JobApi.MetricResults.newBuilder().addAllAttempted(monitoringInfos).build();
    }

    static class Detached
    extends FlinkDetachedRunnerResult
    implements PortablePipelineResult {
        Detached() {
        }

        public JobApi.MetricResults portableMetrics() throws UnsupportedOperationException {
            LOG.warn("Collecting monitoring infos is not implemented yet in Flink portable runner (detached mode).");
            return JobApi.MetricResults.newBuilder().build();
        }
    }
}

