/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.io.Closeable;
import java.io.IOException;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.joda.time.Instant;

public class DoFnRunnerWithMetricsUpdate<InputT, OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final String stepName;
    private final FlinkMetricContainer container;
    private final DoFnRunner<InputT, OutputT> delegate;

    public DoFnRunnerWithMetricsUpdate(String stepName, DoFnRunner<InputT, OutputT> delegate, RuntimeContext runtimeContext) {
        this.stepName = stepName;
        this.delegate = delegate;
        this.container = new FlinkMetricContainer(runtimeContext);
    }

    public void startBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.startBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processElement(WindowedValue<InputT> elem) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.processElement(elem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onTimer(String timerId, BoundedWindow window, Instant timestamp, TimeDomain timeDomain) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.onTimer(timerId, window, timestamp, timeDomain);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.finishBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.container.updateMetrics(this.stepName);
    }

    public DoFn<InputT, OutputT> getFn() {
        return this.delegate.getFn();
    }
}

