/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.flink.translation.wrappers.streaming.PushedBackElementsHandler;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;

class KeyedPushedBackElementsHandler<K, T>
implements PushedBackElementsHandler<T> {
    private final KeySelector<T, K> keySelector;
    private final KeyedStateBackend<K> backend;
    private final String stateName;
    private final ListState<T> state;

    static <K, T> KeyedPushedBackElementsHandler<K, T> create(KeySelector<T, K> keySelector, KeyedStateBackend<K> backend, ListStateDescriptor<T> stateDescriptor) throws Exception {
        return new KeyedPushedBackElementsHandler<K, T>(keySelector, backend, stateDescriptor);
    }

    private KeyedPushedBackElementsHandler(KeySelector<T, K> keySelector, KeyedStateBackend<K> backend, ListStateDescriptor<T> stateDescriptor) throws Exception {
        this.keySelector = keySelector;
        this.backend = backend;
        this.stateName = stateDescriptor.getName();
        this.state = (ListState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, stateDescriptor);
    }

    @Override
    public Stream<T> getElements() {
        return this.backend.getKeys(this.stateName, (Object)VoidNamespace.INSTANCE).flatMap(key -> {
            try {
                this.backend.setCurrentKey(key);
                return StreamSupport.stream(((Iterable)this.state.get()).spliterator(), false);
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading keyed state.", e);
            }
        });
    }

    @Override
    public void clear() throws Exception {
        List keys = this.backend.getKeys(this.stateName, (Object)VoidNamespace.INSTANCE).collect(Collectors.toList());
        for (Object key : keys) {
            this.backend.setCurrentKey(key);
            this.state.clear();
        }
    }

    @Override
    public void pushBack(T element) throws Exception {
        this.backend.setCurrentKey(this.keySelector.getKey(element));
        this.state.add(element);
    }

    @Override
    public void pushBackAll(Iterable<T> elements) throws Exception {
        for (T e : elements) {
            this.pushBack(e);
        }
    }
}

