/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.GroupAlsoByWindowViaWindowSetNewDoFn;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItems;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.TimerInternalsFactory;
import org.apache.beam.runners.flink.translation.wrappers.streaming.DoFnOperator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.InternalTimer;

public class WindowDoFnOperator<K, InputT, OutputT>
extends DoFnOperator<KeyedWorkItem<K, InputT>, KV<K, OutputT>> {
    private final SystemReduceFn<K, InputT, ?, OutputT, BoundedWindow> systemReduceFn;

    public WindowDoFnOperator(SystemReduceFn<K, InputT, ?, OutputT, BoundedWindow> systemReduceFn, String stepName, Coder<WindowedValue<KeyedWorkItem<K, InputT>>> windowedInputCoder, TupleTag<KV<K, OutputT>> mainOutputTag, List<TupleTag<?>> additionalOutputTags, DoFnOperator.OutputManagerFactory<KV<K, OutputT>> outputManagerFactory, WindowingStrategy<?, ?> windowingStrategy, Map<Integer, PCollectionView<?>> sideInputTagMapping, Collection<PCollectionView<?>> sideInputs, PipelineOptions options, Coder<K> keyCoder, KeySelector<WindowedValue<KeyedWorkItem<K, InputT>>, ?> keySelector) {
        super(null, stepName, windowedInputCoder, null, Collections.emptyMap(), mainOutputTag, additionalOutputTags, outputManagerFactory, windowingStrategy, sideInputTagMapping, sideInputs, options, keyCoder, keySelector, DoFnSchemaInformation.create(), Collections.emptyMap());
        this.systemReduceFn = systemReduceFn;
    }

    @Override
    protected DoFnRunner<KeyedWorkItem<K, InputT>, KV<K, OutputT>> createWrappingDoFnRunner(DoFnRunner<KeyedWorkItem<K, InputT>, KV<K, OutputT>> wrappedRunner) {
        return DoFnRunners.lateDataDroppingRunner((DoFnRunner)this.doFnRunner, (TimerInternals)this.timerInternals, (WindowingStrategy)this.windowingStrategy);
    }

    @Override
    protected DoFn<KeyedWorkItem<K, InputT>, KV<K, OutputT>> getDoFn() {
        StateInternalsFactory stateInternalsFactory = key -> this.keyedStateInternals;
        TimerInternalsFactory timerInternalsFactory = key -> this.timerInternals;
        DoFn doFn = GroupAlsoByWindowViaWindowSetNewDoFn.create((WindowingStrategy)this.windowingStrategy, (StateInternalsFactory)stateInternalsFactory, (TimerInternalsFactory)timerInternalsFactory, (SideInputReader)this.sideInputReader, this.systemReduceFn, (DoFnRunners.OutputManager)this.outputManager, (TupleTag)this.mainOutputTag);
        return doFn;
    }

    @Override
    protected void fireTimer(InternalTimer<ByteBuffer, TimerInternals.TimerData> timer) {
        this.timerInternals.cleanupPendingTimer((TimerInternals.TimerData)timer.getNamespace());
        this.doFnRunner.processElement(WindowedValue.valueInGlobalWindow((Object)KeyedWorkItems.timersWorkItem(this.keyedStateInternals.getKey(), Collections.singletonList((TimerInternals.TimerData)timer.getNamespace()))));
    }
}

