/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.nio.ByteBuffer;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.runners.flink.translation.wrappers.streaming.SingletonKeyedWorkItem;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;

public class WorkItemKeySelector<K, V>
implements KeySelector<WindowedValue<SingletonKeyedWorkItem<K, V>>, ByteBuffer>,
ResultTypeQueryable<ByteBuffer> {
    private final Coder<K> keyCoder;

    public WorkItemKeySelector(Coder<K> keyCoder) {
        this.keyCoder = keyCoder;
    }

    public ByteBuffer getKey(WindowedValue<SingletonKeyedWorkItem<K, V>> value) throws Exception {
        Object key = ((SingletonKeyedWorkItem)value.getValue()).key();
        return FlinkKeyUtils.encodeKey(key, this.keyCoder);
    }

    public TypeInformation<ByteBuffer> getProducedType() {
        return new GenericTypeInfo(ByteBuffer.class);
    }
}

