/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.services.dataflow.Dataflow;
import java.util.Map;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.DataflowTransport;
import org.apache.beam.runners.dataflow.util.GcsStager;
import org.apache.beam.runners.dataflow.util.Stager;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.InstanceBuilder;

@Description(value="[Internal] Options used to control execution of the Dataflow SDK for debugging and testing purposes.")
@Hidden
public interface DataflowPipelineDebugOptions
extends ExperimentalOptions,
PipelineOptions {
    @Description(value="The root URL for the Dataflow API. dataflowEndpoint can override this value if it contains an absolute URL, otherwise apiRootUrl will be combined with dataflowEndpoint to generate the full URL to communicate with the Dataflow API.")
    @Default.String(value="https://dataflow.googleapis.com/")
    public String getApiRootUrl();

    public void setApiRootUrl(String var1);

    @Description(value="The URL for the Dataflow API. If the string contains \"://\", this will be treated as the entire URL, otherwise will be treated relative to apiRootUrl.")
    @Default.String(value="")
    public String getDataflowEndpoint();

    public void setDataflowEndpoint(String var1);

    @Description(value="The path to write the translated Dataflow job specification out to at job submission time. The Dataflow job specification will be represented in JSON format.")
    public String getDataflowJobFile();

    public void setDataflowJobFile(String var1);

    @Description(value="The class of the stager that should be created and used to stage resources. If stager has not been set explicitly, an instance of the this class will be created and used as the resource stager.")
    @Default.Class(value=GcsStager.class)
    public Class<? extends Stager> getStagerClass();

    public void setStagerClass(Class<? extends Stager> var1);

    @JsonIgnore
    @Description(value="The resource stager instance that should be used to stage resources. If no stager has been set explicitly, the default is to use the instance factory that constructs a resource stager based upon the currently set stagerClass.")
    @Default.InstanceFactory(value=StagerFactory.class)
    public Stager getStager();

    public void setStager(Stager var1);

    @JsonIgnore
    @Description(value="An instance of the Dataflow client. Defaults to creating a Dataflow client using the current set of options.")
    @Default.InstanceFactory(value=DataflowClientFactory.class)
    public Dataflow getDataflowClient();

    public void setDataflowClient(Dataflow var1);

    @JsonIgnore
    @Description(value="Mapping of old PTranform names to new ones, specified as JSON {\"oldName\":\"newName\",...}. To mark a transform as deleted, make newName the empty string.")
    public Map<String, String> getTransformNameMapping();

    public void setTransformNameMapping(Map<String, String> var1);

    @Description(value="Custom windmill_main binary to use with the streaming runner")
    public String getOverrideWindmillBinary();

    public void setOverrideWindmillBinary(String var1);

    @Description(value="Custom windmill service endpoint.")
    public String getWindmillServiceEndpoint();

    public void setWindmillServiceEndpoint(String var1);

    @Description(value="Port for communicating with a remote windmill service.")
    @Default.Integer(value=443)
    public int getWindmillServicePort();

    public void setWindmillServicePort(int var1);

    @Description(value="Number of threads to use on the Dataflow worker harness. If left unspecified, the Dataflow service will compute an appropriate number of threads to use.")
    public int getNumberOfWorkerHarnessThreads();

    public void setNumberOfWorkerHarnessThreads(int var1);

    @Description(value="If {@literal true}, save a heap dump before killing a thread or process which is GC thrashing or out of memory.")
    public boolean getDumpHeapOnOOM();

    public void setDumpHeapOnOOM(boolean var1);

    @Description(value="The GC thrashing threshold percentage. A given period of time is considered \"thrashing\" if this percentage of CPU time is spent in garbage collection. Dataflow will force fail tasks after sustained periods of thrashing.")
    @Default.Double(value=50.0)
    public Double getGCThrashingPercentagePerPeriod();

    public void setGCThrashingPercentagePerPeriod(Double var1);

    @Description(value="The size of the worker's in-memory cache, in megabytes.")
    @Default.Integer(value=100)
    public Integer getWorkerCacheMb();

    public void setWorkerCacheMb(Integer var1);

    @Description(value="The amount of time before UnboundedReaders are uncached, in seconds.")
    @Default.Integer(value=60)
    public Integer getReaderCacheTimeoutSec();

    public void setReaderCacheTimeoutSec(Integer var1);

    @Description(value="The max amount of time before an UnboundedReader is consumed before checkpointing, in seconds.")
    @Default.Integer(value=10)
    public Integer getUnboundedReaderMaxReadTimeSec();

    public void setUnboundedReaderMaxReadTimeSec(Integer var1);

    @Description(value="The max elements read from an UnboundedReader before checkpointing. ")
    @Default.Integer(value=10000)
    public Integer getUnboundedReaderMaxElements();

    public void setUnboundedReaderMaxElements(Integer var1);

    @Description(value="The max amount of time waiting for elements when reading from UnboundedReader.")
    @Default.Integer(value=1000)
    public Integer getUnboundedReaderMaxWaitForElementsMs();

    public void setUnboundedReaderMaxWaitForElementsMs(Integer var1);

    @Description(value="[EXPERIMENTAL] Set to a GCS bucket (directory) to upload heap dumps to the given location.\nEnabling this implies that heap dumps should be generated on OOM (--dumpHeapOnOOM=true)\nUploads will continue until the pipeline is stopped or updated without this option.\n")
    @Experimental
    public String getSaveHeapDumpsToGcsPath();

    public void setSaveHeapDumpsToGcsPath(String var1);

    @Description(value="Overrides for SDK harness container images. Each entry consist of two values separated by \na comma where first value gives a regex to identify the container image to override \nand the second value gives the replacement container image.")
    public String getSdkHarnessContainerImageOverrides();

    public void setSdkHarnessContainerImageOverrides(String var1);

    public static class StagerFactory
    implements DefaultValueFactory<Stager> {
        public Stager create(PipelineOptions options) {
            DataflowPipelineDebugOptions debugOptions = (DataflowPipelineDebugOptions)options.as(DataflowPipelineDebugOptions.class);
            return (Stager)InstanceBuilder.ofType(Stager.class).fromClass(debugOptions.getStagerClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, (Object)options).build();
        }
    }

    public static class DataflowClientFactory
    implements DefaultValueFactory<Dataflow> {
        public Dataflow create(PipelineOptions options) {
            return DataflowTransport.newDataflowClient((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class)).build();
        }
    }
}

