/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.services.dataflow.model.JobMessage;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.TimeUtil;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringUtil {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MonitoringUtil.class);
    private static final @UnknownKeyFor @NonNull @Initialized String GCLOUD_DATAFLOW_PREFIX = "gcloud dataflow";
    private static final @UnknownKeyFor @NonNull @Initialized String ENDPOINT_OVERRIDE_ENV_VAR = "CLOUDSDK_API_ENDPOINT_OVERRIDES_DATAFLOW";
    private static final @UnknownKeyFor @NonNull @Initialized String JOB_MESSAGE_ERROR = "JOB_MESSAGE_ERROR";
    private static final @UnknownKeyFor @NonNull @Initialized String JOB_MESSAGE_WARNING = "JOB_MESSAGE_WARNING";
    private static final @UnknownKeyFor @NonNull @Initialized String JOB_MESSAGE_BASIC = "JOB_MESSAGE_BASIC";
    private static final @UnknownKeyFor @NonNull @Initialized String JOB_MESSAGE_DETAILED = "JOB_MESSAGE_DETAILED";
    private static final @UnknownKeyFor @NonNull @Initialized String JOB_MESSAGE_DEBUG = "JOB_MESSAGE_DEBUG";
    private final @UnknownKeyFor @NonNull @Initialized DataflowClient dataflowClient;

    public MonitoringUtil(@UnknownKeyFor @NonNull @Initialized DataflowClient dataflowClient) {
        this.dataflowClient = dataflowClient;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized JobMessage> getJobMessages(@UnknownKeyFor @NonNull @Initialized String jobId, @UnknownKeyFor @NonNull @Initialized long startTimestampMs) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Instant startTimestamp = new Instant(startTimestampMs);
        ArrayList<JobMessage> allMessages = new ArrayList<JobMessage>();
        String pageToken = null;
        while (true) {
            ListJobMessagesResponse response;
            if ((response = this.dataflowClient.listJobMessages(jobId, pageToken)) == null || response.getJobMessages() == null) {
                return allMessages;
            }
            for (JobMessage m : response.getJobMessages()) {
                @Nullable Instant timestamp = TimeUtil.fromCloudTime(m.getTime());
                if (timestamp == null || !timestamp.isAfter((ReadableInstant)startTimestamp)) continue;
                allMessages.add(m);
            }
            if (response.getNextPageToken() == null) break;
            pageToken = response.getNextPageToken();
        }
        allMessages.sort(new TimeStampComparator());
        return allMessages;
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String getJobMonitoringPageURL(@UnknownKeyFor @NonNull @Initialized String projectName, @UnknownKeyFor @NonNull @Initialized String jobId) {
        return MonitoringUtil.getJobMonitoringPageURL(projectName, "us-central1", jobId);
    }

    public static @UnknownKeyFor @NonNull @Initialized String getJobMonitoringPageURL(@UnknownKeyFor @NonNull @Initialized String projectName, @UnknownKeyFor @NonNull @Initialized String regionId, @UnknownKeyFor @NonNull @Initialized String jobId) {
        try {
            return String.format("https://console.cloud.google.com/dataflow/jobs/%s/%s?project=%s", URLEncoder.encode(regionId, StandardCharsets.UTF_8.name()), URLEncoder.encode(jobId, StandardCharsets.UTF_8.name()), URLEncoder.encode(projectName, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 encoding is not supported by the environment", e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String getGcloudCancelCommand(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options, @UnknownKeyFor @NonNull @Initialized String jobId) {
        String dataflowApiOverridePrefix = "";
        String apiUrl = options.getDataflowClient().getBaseUrl();
        if (!apiUrl.equals("https://dataflow.googleapis.com/")) {
            dataflowApiOverridePrefix = String.format("%s=%s ", ENDPOINT_OVERRIDE_ENV_VAR, apiUrl);
        }
        return String.format("%s%s jobs --project=%s cancel --region=%s %s", dataflowApiOverridePrefix, GCLOUD_DATAFLOW_PREFIX, options.getProject(), options.getRegion(), jobId);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineResult.State toState(@Nullable @UnknownKeyFor @Initialized String stateName) {
        if (stateName == null) {
            return PipelineResult.State.UNRECOGNIZED;
        }
        switch (stateName) {
            case "JOB_STATE_UNKNOWN": {
                return PipelineResult.State.UNKNOWN;
            }
            case "JOB_STATE_STOPPED": {
                return PipelineResult.State.STOPPED;
            }
            case "JOB_STATE_FAILED": {
                return PipelineResult.State.FAILED;
            }
            case "JOB_STATE_CANCELLED": {
                return PipelineResult.State.CANCELLED;
            }
            case "JOB_STATE_UPDATED": {
                return PipelineResult.State.UPDATED;
            }
            case "JOB_STATE_RUNNING": 
            case "JOB_STATE_PENDING": 
            case "JOB_STATE_DRAINING": 
            case "JOB_STATE_CANCELLING": 
            case "JOB_STATE_RESOURCE_CLEANING_UP": {
                return PipelineResult.State.RUNNING;
            }
            case "JOB_STATE_DONE": 
            case "JOB_STATE_DRAINED": {
                return PipelineResult.State.DONE;
            }
        }
        LOG.warn("Unrecognized state from Dataflow service: {}. This is likely due to using an older version of Beam.", (Object)stateName);
        return PipelineResult.State.UNRECOGNIZED;
    }

    public static class TimeStampComparator
    implements Comparator<JobMessage>,
    Serializable {
        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized JobMessage o1, @UnknownKeyFor @NonNull @Initialized JobMessage o2) {
            @Nullable Instant t1 = TimeUtil.fromCloudTime(o1.getTime());
            if (t1 == null) {
                return -1;
            }
            @Nullable Instant t2 = TimeUtil.fromCloudTime(o2.getTime());
            if (t2 == null) {
                return 1;
            }
            return t1.compareTo((ReadableInstant)t2);
        }
    }

    public static class LoggingHandler
    implements JobMessagesHandler {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(LoggingHandler.class);

        @Override
        public void process(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized JobMessage> messages) {
            block13: for (JobMessage message : messages) {
                if (Strings.isNullOrEmpty((String)message.getMessageText())) continue;
                @Nullable Instant time = TimeUtil.fromCloudTime(message.getTime());
                String logMessage = (time == null ? "UNKNOWN TIMESTAMP: " : time + ": ") + message.getMessageText();
                switch (message.getMessageImportance()) {
                    case "JOB_MESSAGE_ERROR": {
                        LOG.error(logMessage);
                        continue block13;
                    }
                    case "JOB_MESSAGE_WARNING": {
                        LOG.warn(logMessage);
                        continue block13;
                    }
                    case "JOB_MESSAGE_BASIC": 
                    case "JOB_MESSAGE_DETAILED": {
                        LOG.info(logMessage);
                        continue block13;
                    }
                    case "JOB_MESSAGE_DEBUG": {
                        LOG.debug(logMessage);
                        continue block13;
                    }
                }
                LOG.trace(logMessage);
            }
        }
    }

    public static interface JobMessagesHandler {
        public void process(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized JobMessage> var1);
    }
}

