/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnExternalWorkerPoolGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.runners.fnexecution.GrpcFnServer;
import org.apache.beam.runners.fnexecution.ServerFactory;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.DockerEnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.ManagedChannel;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalEnvironmentFactory
implements EnvironmentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalEnvironmentFactory.class);
    private static final boolean IS_WORKER_POOL_IN_DOCKER_VM = System.getenv().containsKey("BEAM_WORKER_POOL_IN_DOCKER_VM");
    private final GrpcFnServer<FnApiControlClientPoolService> controlServiceServer;
    private final GrpcFnServer<GrpcLoggingService> loggingServiceServer;
    private final GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer;
    private final GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer;
    private final IdGenerator idGenerator;
    private final ControlClientPool.Source clientSource;

    public static ExternalEnvironmentFactory create(GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, ControlClientPool.Source clientSource, IdGenerator idGenerator) {
        return new ExternalEnvironmentFactory(controlServiceServer, loggingServiceServer, retrievalServiceServer, provisioningServiceServer, idGenerator, clientSource);
    }

    private ExternalEnvironmentFactory(GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, IdGenerator idGenerator, ControlClientPool.Source clientSource) {
        this.controlServiceServer = controlServiceServer;
        this.loggingServiceServer = loggingServiceServer;
        this.retrievalServiceServer = retrievalServiceServer;
        this.provisioningServiceServer = provisioningServiceServer;
        this.idGenerator = idGenerator;
        this.clientSource = clientSource;
    }

    @Override
    public RemoteEnvironment createEnvironment(final RunnerApi.Environment environment, final String workerId) throws Exception {
        Preconditions.checkState((boolean)environment.getUrn().equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.EXTERNAL)), (Object)"The passed environment does not contain an ExternalPayload.");
        RunnerApi.ExternalPayload externalPayload = RunnerApi.ExternalPayload.parseFrom((ByteString)environment.getPayload());
        BeamFnApi.StartWorkerRequest startWorkerRequest = BeamFnApi.StartWorkerRequest.newBuilder().setWorkerId(workerId).setControlEndpoint(this.controlServiceServer.getApiServiceDescriptor()).setLoggingEndpoint(this.loggingServiceServer.getApiServiceDescriptor()).setArtifactEndpoint(this.retrievalServiceServer.getApiServiceDescriptor()).setProvisionEndpoint(this.provisioningServiceServer.getApiServiceDescriptor()).putAllParams(externalPayload.getParamsMap()).build();
        LOG.debug("Requesting worker ID {}", (Object)workerId);
        final ManagedChannel managedChannel = ManagedChannelFactory.createDefault().forDescriptor(externalPayload.getEndpoint());
        BeamFnApi.StartWorkerResponse startWorkerResponse = BeamFnExternalWorkerPoolGrpc.newBlockingStub((Channel)managedChannel).startWorker(startWorkerRequest);
        if (!startWorkerResponse.getError().isEmpty()) {
            throw new RuntimeException(startWorkerResponse.getError());
        }
        InstructionRequestHandler instructionHandler = null;
        while (instructionHandler == null) {
            try {
                instructionHandler = this.clientSource.take(workerId, Duration.ofMinutes(2L));
            }
            catch (TimeoutException timeoutEx) {
                LOG.info("Still waiting for startup of environment from {} for worker id {}", (Object)externalPayload.getEndpoint().getUrl(), (Object)workerId);
            }
            catch (InterruptedException interruptEx) {
                Thread.currentThread().interrupt();
                managedChannel.shutdownNow();
                throw new RuntimeException(interruptEx);
            }
        }
        final InstructionRequestHandler finalInstructionHandler = instructionHandler;
        return new RemoteEnvironment(){

            @Override
            public RunnerApi.Environment getEnvironment() {
                return environment;
            }

            @Override
            public InstructionRequestHandler getInstructionRequestHandler() {
                return finalInstructionHandler;
            }

            @Override
            public void close() throws Exception {
                try {
                    finalInstructionHandler.close();
                    BeamFnApi.StopWorkerRequest stopWorkerRequest = BeamFnApi.StopWorkerRequest.newBuilder().setWorkerId(workerId).build();
                    LOG.debug("Closing worker ID {}", (Object)workerId);
                    BeamFnApi.StopWorkerResponse stopWorkerResponse = BeamFnExternalWorkerPoolGrpc.newBlockingStub((Channel)managedChannel).stopWorker(stopWorkerRequest);
                    if (!stopWorkerResponse.getError().isEmpty()) {
                        throw new RuntimeException(stopWorkerResponse.getError());
                    }
                }
                finally {
                    managedChannel.shutdown();
                    managedChannel.awaitTermination(10L, TimeUnit.SECONDS);
                    if (!managedChannel.isTerminated()) {
                        managedChannel.shutdownNow();
                    }
                }
            }
        };
    }

    public static class Provider
    implements EnvironmentFactory.Provider {
        @Override
        public EnvironmentFactory createEnvironmentFactory(GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, ControlClientPool clientPool, IdGenerator idGenerator) {
            return ExternalEnvironmentFactory.create(controlServiceServer, loggingServiceServer, retrievalServiceServer, provisioningServiceServer, clientPool.getSource(), idGenerator);
        }

        @Override
        public ServerFactory getServerFactory() {
            if (IS_WORKER_POOL_IN_DOCKER_VM) {
                return DockerEnvironmentFactory.DockerOnMac.getServerFactory();
            }
            return ServerFactory.createDefault();
        }
    }
}

