/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.aggregators;

import org.apache.beam.runners.spark.structuredstreaming.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.structuredstreaming.aggregators.NamedAggregatorsAccumulator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.AccumulatorV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorsAccumulator {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatorsAccumulator.class);
    private static final String ACCUMULATOR_NAME = "Beam.Aggregators";
    private static volatile NamedAggregatorsAccumulator instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(JavaSparkContext jsc) {
        if (instance != null) return;
        Class<AggregatorsAccumulator> clazz = AggregatorsAccumulator.class;
        synchronized (AggregatorsAccumulator.class) {
            if (instance == null) {
                NamedAggregators namedAggregators = new NamedAggregators();
                NamedAggregatorsAccumulator accumulator = new NamedAggregatorsAccumulator(namedAggregators);
                jsc.sc().register((AccumulatorV2)accumulator, ACCUMULATOR_NAME);
                instance = accumulator;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOG.info("Instantiated aggregators accumulator: {}", (Object)instance.value());
            return;
        }
    }

    public static NamedAggregatorsAccumulator getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Aggregrators accumulator has not been instantiated");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clear() {
        Class<AggregatorsAccumulator> clazz = AggregatorsAccumulator.class;
        synchronized (AggregatorsAccumulator.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

