/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.spark.SparkException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class SparkStructuredStreamingPipelineResult
implements PipelineResult {
    final @UnknownKeyFor @NonNull @Initialized Future pipelineExecution;
    final @UnknownKeyFor @NonNull @Initialized SparkSession sparkSession;
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State state;
    @UnknownKeyFor @NonNull @Initialized boolean isStreaming;

    SparkStructuredStreamingPipelineResult(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> pipelineExecution, @UnknownKeyFor @NonNull @Initialized SparkSession sparkSession) {
        this.pipelineExecution = pipelineExecution;
        this.sparkSession = sparkSession;
        this.state = PipelineResult.State.RUNNING;
        this.isStreaming = false;
    }

    private static @UnknownKeyFor @NonNull @Initialized RuntimeException runtimeExceptionFrom(@UnknownKeyFor @NonNull @Initialized Throwable e) {
        return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    private static @UnknownKeyFor @NonNull @Initialized RuntimeException beamExceptionFrom(@UnknownKeyFor @NonNull @Initialized Throwable e) {
        if (e instanceof SparkException) {
            if (e.getCause() != null && e.getCause() instanceof UserCodeException) {
                UserCodeException userException = (UserCodeException)e.getCause();
                return new Pipeline.PipelineExecutionException(userException.getCause());
            }
            if (e.getCause() != null) {
                return new Pipeline.PipelineExecutionException(e.getCause());
            }
        }
        return SparkStructuredStreamingPipelineResult.runtimeExceptionFrom(e);
    }

    protected void stop() {
        try {
            if (this.isStreaming) {
                for (StreamingQuery query : this.sparkSession.streams().active()) {
                    query.stop();
                }
            }
        }
        catch (Exception e) {
            throw SparkStructuredStreamingPipelineResult.beamExceptionFrom(e);
        }
        finally {
            this.sparkSession.stop();
            if (Objects.equals(this.state, PipelineResult.State.RUNNING)) {
                this.state = PipelineResult.State.STOPPED;
            }
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State awaitTermination(@UnknownKeyFor @NonNull @Initialized Duration duration) throws @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        this.pipelineExecution.get(duration.getMillis(), TimeUnit.MILLISECONDS);
        return PipelineResult.State.DONE;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State getState() {
        return this.state;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(Duration.millis((long)Long.MAX_VALUE));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        try {
            PipelineResult.State finishState = this.awaitTermination(duration);
            this.offerNewState(finishState);
        }
        catch (TimeoutException finishState) {
        }
        catch (ExecutionException e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkStructuredStreamingPipelineResult.beamExceptionFrom(e.getCause());
        }
        catch (Exception e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkStructuredStreamingPipelineResult.beamExceptionFrom(e);
        }
        return this.state;
    }

    public @UnknownKeyFor @NonNull @Initialized MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)MetricsAccumulator.getInstance().value());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State cancel() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.offerNewState(PipelineResult.State.CANCELLED);
        return this.state;
    }

    private void offerNewState(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State newState) {
        PipelineResult.State oldState = this.state;
        this.state = newState;
        if (!oldState.isTerminal() && newState.isTerminal()) {
            this.stop();
        }
    }
}

