/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import org.apache.beam.runners.spark.structuredstreaming.translation.AbstractTranslationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.WindowingHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.spark.sql.Dataset;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class WindowAssignTranslatorBatch<@UnknownKeyFor T>
implements TransformTranslator<PTransform<PCollection<T>, PCollection<T>>> {
    WindowAssignTranslatorBatch() {
    }

    @Override
    public void translateTransform(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> transform, @UnknownKeyFor @NonNull @Initialized AbstractTranslationContext context) {
        Window.Assign assignTransform = (Window.Assign)transform;
        PCollection input = (PCollection)context.getInput();
        PCollection output = (PCollection)context.getOutput();
        Dataset inputDataset = context.getDataset((PValue)input);
        if (WindowingHelpers.skipAssignWindows(assignTransform, context)) {
            context.putDataset((PValue)output, inputDataset);
        } else {
            WindowFn windowFn = assignTransform.getWindowFn();
            WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.FullWindowedValueCoder.of((Coder)input.getCoder(), (Coder)windowFn.windowCoder());
            Dataset outputDataset = inputDataset.map(WindowingHelpers.assignWindowsMapFunction(windowFn), EncoderHelpers.fromBeamCoder(windowedValueCoder));
            context.putDataset((PValue)output, outputDataset);
        }
    }
}

