/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.beam.sdk.expansion.service.ExpansionServiceConfig;
import org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProvider;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface ExpansionServiceOptions
extends PipelineOptions {
    @Description(value="Allow list for Java class based transform expansion")
    @Default.InstanceFactory(value=JavaClassLookupAllowListFactory.class)
    public  @UnknownKeyFor @NonNull @Initialized JavaClassLookupTransformProvider.AllowList getJavaClassLookupAllowlist();

    public void setJavaClassLookupAllowlist( @UnknownKeyFor @NonNull @Initialized JavaClassLookupTransformProvider.AllowList var1);

    @Description(value="Allow list file for Java class based transform expansion, or '*' to allow anything.")
    public @UnknownKeyFor @NonNull @Initialized String getJavaClassLookupAllowlistFile();

    public void setJavaClassLookupAllowlistFile(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Whether to also start a loopback worker as part of this service.")
    public @UnknownKeyFor @NonNull @Initialized boolean getAlsoStartLoopbackWorker();

    public void setAlsoStartLoopbackWorker(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="Expansion service configuration file.")
    public @UnknownKeyFor @NonNull @Initialized String getExpansionServiceConfigFile();

    public void setExpansionServiceConfigFile(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Expansion service configuration.")
    @Default.InstanceFactory(value=ExpansionServiceConfigFactory.class)
    public @UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig getExpansionServiceConfig();

    public void setExpansionServiceConfig(@UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig var1);

    @Description(value="Starts an Expansion Service with support for gRPC ALTS authentication.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean getUseAltsServer();

    public void setUseAltsServer(@UnknownKeyFor @NonNull @Initialized boolean var1);

    public static class ExpansionServiceConfigFactory
    implements DefaultValueFactory<ExpansionServiceConfig> {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public @UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String configFile = ((ExpansionServiceOptions)options.as(ExpansionServiceOptions.class)).getExpansionServiceConfigFile();
            if (configFile == null) return ExpansionServiceConfig.empty();
            File configFileObj = new File(configFile);
            if (!configFileObj.exists()) {
                throw new IllegalArgumentException("Config file " + configFile + " does not exist");
            }
            try (FileInputStream stream = new FileInputStream(configFileObj);){
                ExpansionServiceConfig expansionServiceConfig = ExpansionServiceConfig.parseFromYamlStream(stream);
                return expansionServiceConfig;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not parse the provided Expansion Service config file" + configFile, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse the provided Expansion Service config file" + configFile, e);
            }
        }
    }

    public static class JavaClassLookupAllowListFactory
    implements DefaultValueFactory<JavaClassLookupTransformProvider.AllowList> {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public  @UnknownKeyFor @NonNull @Initialized JavaClassLookupTransformProvider.AllowList create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String allowListFile = ((ExpansionServiceOptions)options.as(ExpansionServiceOptions.class)).getJavaClassLookupAllowlistFile();
            if (allowListFile == null) return JavaClassLookupTransformProvider.AllowList.nothing();
            if (allowListFile.equals("*")) {
                return JavaClassLookupTransformProvider.AllowList.everything();
            }
            File allowListFileObj = new File(allowListFile);
            if (!allowListFileObj.exists()) {
                throw new IllegalArgumentException("Allow list file " + allowListFile + " does not exist");
            }
            try (FileInputStream stream = new FileInputStream(allowListFileObj);){
                JavaClassLookupTransformProvider.AllowList allowList = JavaClassLookupTransformProvider.AllowList.parseFromYamlStream(stream);
                return allowList;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not parse the provided allowlist file " + allowListFile, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse the provided allowlist file " + allowListFile, e);
            }
        }
    }
}

