/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Message;
import java.io.Serializable;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.protobuf.ProtoMessageSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.sdk.schemas.transforms.Cast;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public class ProtoPayloadSerializerProvider
implements PayloadSerializerProvider {
    public String identifier() {
        return "proto";
    }

    private static Class<? extends Message> getClass(Map<String, Object> tableParams) {
        String protoClassName = Preconditions.checkArgumentNotNull((Object)tableParams.get("protoClass")).toString();
        try {
            Class<?> protoClass = Class.forName(protoClassName);
            return protoClass.asSubclass(Message.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Incorrect proto class provided: " + protoClassName, e);
        }
    }

    private static <T extends Message> void inferAndVerifySchema(Class<T> protoClass, Schema requiredSchema) {
        Schema inferredSchema = (Schema)Preconditions.checkArgumentNotNull((Object)new ProtoMessageSchema().schemaFor(TypeDescriptor.of(protoClass)));
        if (!inferredSchema.assignableTo(requiredSchema)) {
            throw new IllegalArgumentException(String.format("Given message schema: '%s'%ndoes not match schema inferred from protobuf class.%nProtobuf class: '%s'%nInferred schema: '%s'", requiredSchema, protoClass.getName(), inferredSchema));
        }
    }

    public PayloadSerializer getSerializer(Schema schema, Map<String, Object> tableParams) {
        Class<? extends Message> protoClass = ProtoPayloadSerializerProvider.getClass(tableParams);
        ProtoPayloadSerializerProvider.inferAndVerifySchema(protoClass, schema);
        SimpleFunction<byte[], Row> toRowFn = ProtoMessageSchema.getProtoBytesToRowFn(protoClass);
        return PayloadSerializer.of(ProtoMessageSchema.getRowToProtoBytesFn(protoClass), (SerializableFunction & Serializable)bytes -> {
            Row rawRow = (Row)toRowFn.apply(bytes);
            return Cast.castRow((Row)rawRow, (Schema)rawRow.getSchema(), (Schema)schema);
        });
    }
}

