/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CountingInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class DataStreams {
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_OUTBOUND_BUFFER_LIMIT_BYTES = 1000000;

    public static @UnknownKeyFor @NonNull @Initialized InputStream inbound(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ByteString> bytes) {
        return new Inbound(bytes);
    }

    public static @UnknownKeyFor @NonNull @Initialized ElementDelimitedOutputStream outbound(@UnknownKeyFor @NonNull @Initialized OutputChunkConsumer<@UnknownKeyFor @NonNull @Initialized ByteString> consumer) {
        return DataStreams.outbound(consumer, 1000000);
    }

    public static @UnknownKeyFor @NonNull @Initialized ElementDelimitedOutputStream outbound(@UnknownKeyFor @NonNull @Initialized OutputChunkConsumer<@UnknownKeyFor @NonNull @Initialized ByteString> consumer, @UnknownKeyFor @NonNull @Initialized int maximumChunkSize) {
        return new ElementDelimitedOutputStream(consumer, maximumChunkSize);
    }

    public static class BlockingQueueIterator<@UnknownKeyFor T>
    implements AutoCloseable,
    Iterator<T> {
        private static final @UnknownKeyFor @NonNull @Initialized Object POISION_PILL = new Object();
        private final @UnknownKeyFor @NonNull @Initialized BlockingQueue<T> queue;
        private T currentElement;

        public BlockingQueueIterator(@UnknownKeyFor @NonNull @Initialized BlockingQueue<T> queue) {
            this.queue = queue;
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.queue.put(POISION_PILL);
        }

        public void accept(T t) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.queue.put(t);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            if (this.currentElement == null) {
                try {
                    this.currentElement = this.queue.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
            }
            return this.currentElement != POISION_PILL;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T rval = this.currentElement;
            this.currentElement = null;
            return rval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DataStreamDecoder<@UnknownKeyFor T>
    implements Iterator<T> {
        private final @UnknownKeyFor @NonNull @Initialized CountingInputStream countingInputStream;
        private final @UnknownKeyFor @NonNull @Initialized PushbackInputStream pushbackInputStream;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
        private @UnknownKeyFor @NonNull @Initialized State currentState = State.READ_REQUIRED;
        private T next;

        public DataStreamDecoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized InputStream inputStream) {
            this.coder = coder;
            this.pushbackInputStream = new PushbackInputStream(inputStream, 1);
            this.countingInputStream = new CountingInputStream((InputStream)this.pushbackInputStream);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            switch (this.currentState) {
                case EOF: {
                    return false;
                }
                case READ_REQUIRED: {
                    try {
                        int nextByte = this.pushbackInputStream.read();
                        if (nextByte == -1) {
                            this.currentState = State.EOF;
                            return false;
                        }
                        this.pushbackInputStream.unread(nextByte);
                        long count = this.countingInputStream.getCount();
                        this.next = this.coder.decode((InputStream)this.countingInputStream);
                        if (this.countingInputStream.getCount() - count == 0L) {
                            Preconditions.checkState((this.countingInputStream.read() != -1 ? 1 : 0) != 0, (Object)"Unexpected EOF reached");
                        }
                        this.currentState = State.HAS_NEXT;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    return true;
                }
                case HAS_NEXT: {
                    return true;
                }
            }
            throw new IllegalStateException(String.format("Unknown state %s", new Object[]{this.currentState}));
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentState = State.READ_REQUIRED;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static enum State {
            READ_REQUIRED,
            HAS_NEXT,
            EOF;

        }
    }

    private static class Inbound<@UnknownKeyFor T>
    extends InputStream {
        private static final @UnknownKeyFor @NonNull @Initialized InputStream EMPTY_STREAM = new InputStream(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
                return -1;
            }
        };
        private final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ByteString> bytes;
        private @UnknownKeyFor @NonNull @Initialized InputStream currentStream = EMPTY_STREAM;

        public Inbound(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ByteString> bytes) {
            this.bytes = bytes;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
            int rval = -1;
            while ((rval = this.currentStream.read()) == -1 && this.bytes.hasNext()) {
                this.currentStream = this.bytes.next().newInput();
            }
            return rval;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int remainingLen = len;
            while ((remainingLen -= ByteStreams.read((InputStream)this.currentStream, (byte[])b, (int)(off + len - remainingLen), (int)remainingLen)) > 0) {
                if (this.bytes.hasNext()) {
                    this.currentStream = this.bytes.next().newInput();
                    continue;
                }
                int bytesRead = len - remainingLen;
                return bytesRead > 0 ? bytesRead : -1;
            }
            return len - remainingLen;
        }
    }

    public static interface OutputChunkConsumer<@UnknownKeyFor T> {
        public void read(T var1) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    public static final class ElementDelimitedOutputStream
    extends OutputStream {
        private final @UnknownKeyFor @NonNull @Initialized OutputChunkConsumer<@UnknownKeyFor @NonNull @Initialized ByteString> consumer;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ByteString.Output output;
        private final @UnknownKeyFor @NonNull @Initialized int maximumChunkSize;
        @UnknownKeyFor @NonNull @Initialized int previousPosition;

        public ElementDelimitedOutputStream(@UnknownKeyFor @NonNull @Initialized OutputChunkConsumer<@UnknownKeyFor @NonNull @Initialized ByteString> consumer, @UnknownKeyFor @NonNull @Initialized int maximumChunkSize) {
            this.consumer = consumer;
            this.maximumChunkSize = maximumChunkSize;
            this.output = ByteString.newOutput((int)maximumChunkSize);
        }

        public void delimitElement() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.previousPosition == this.output.size()) {
                this.write(0);
            }
            this.previousPosition = this.output.size();
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized int i) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.output.write(i);
            if (this.maximumChunkSize == this.output.size()) {
                this.internalFlush();
            }
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int spaceRemaining = this.maximumChunkSize - this.output.size();
            if (length > spaceRemaining) {
                this.output.write(b, offset, spaceRemaining);
                offset += spaceRemaining;
                length -= spaceRemaining;
                this.internalFlush();
            }
            while (length > this.maximumChunkSize) {
                this.output.write(b, offset, this.maximumChunkSize);
                offset += this.maximumChunkSize;
                length -= this.maximumChunkSize;
                this.internalFlush();
            }
            this.output.write(b, offset, length);
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.output.size() > 0) {
                this.consumer.read(this.output.toByteString());
            }
            this.output.close();
        }

        private void internalFlush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.consumer.read(this.output.toByteString());
            this.output.reset();
            this.previousPosition = -1;
        }
    }
}

