/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BeamFnDataGrpcMultiplexer
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BeamFnDataGrpcMultiplexer.class);
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> inboundObserver;
    private final @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> outboundObserver;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized LogicalEndpoint, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Boolean>>> consumers;

    public BeamFnDataGrpcMultiplexer(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory outboundObserverFactory, @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory.BasicFactory<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> baseOutboundObserverFactory) {
        this.apiServiceDescriptor = apiServiceDescriptor;
        this.consumers = new ConcurrentHashMap<LogicalEndpoint, CompletableFuture<BiConsumer<ByteString, Boolean>>>();
        this.inboundObserver = new InboundObserver();
        this.outboundObserver = outboundObserverFactory.outboundObserverFor(baseOutboundObserverFactory, this.inboundObserver);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("apiServiceDescriptor", (Object)this.apiServiceDescriptor).add("consumers", this.consumers).toString();
    }

    public @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> getInboundObserver() {
        return this.inboundObserver;
    }

    public @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> getOutboundObserver() {
        return this.outboundObserver;
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Boolean>> receiverFuture(@UnknownKeyFor @NonNull @Initialized LogicalEndpoint endpoint) {
        return this.consumers.computeIfAbsent(endpoint, unused -> new CompletableFuture());
    }

    public <T> void registerConsumer(@UnknownKeyFor @NonNull @Initialized LogicalEndpoint inputLocation, @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Boolean> bytesReceiver) {
        this.receiverFuture(inputLocation).complete(bytesReceiver);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized boolean hasConsumer(@UnknownKeyFor @NonNull @Initialized LogicalEndpoint outputLocation) {
        return this.consumers.containsKey(outputLocation);
    }

    @Override
    public void close() {
        for (CompletableFuture receiver : ImmutableList.copyOf(this.consumers.values())) {
            receiver.cancel(true);
        }
        this.outboundObserver.onError((Throwable)Status.CANCELLED.withDescription("Multiplexer hanging up").asException());
        this.inboundObserver.onCompleted();
    }

    private final class InboundObserver
    implements StreamObserver<BeamFnApi.Elements> {
        private InboundObserver() {
        }

        public void onNext(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements value) {
            for (BeamFnApi.Elements.Data maybeData : value.getDataList()) {
                BeamFnApi.Elements.Data data = (BeamFnApi.Elements.Data)Preconditions.checkArgumentNotNull((Object)maybeData);
                try {
                    LogicalEndpoint key = LogicalEndpoint.data(data.getInstructionId(), data.getTransformId());
                    CompletableFuture consumer = BeamFnDataGrpcMultiplexer.this.receiverFuture(key);
                    if (!consumer.isDone()) {
                        LOG.debug("Received data for key {} without consumer ready. Waiting for consumer to be registered.", (Object)key);
                    }
                    ((BiConsumer)consumer.get()).accept(data.getData(), data.getIsLast());
                    if (!data.getIsLast()) continue;
                    BeamFnDataGrpcMultiplexer.this.consumers.remove(key);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Client interrupted during handling of data for instruction {} and transform {}", new Object[]{data.getInstructionId(), data.getTransformId(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                }
                catch (RuntimeException e) {
                    LOG.error("Client failed to handle data for instruction {} and transform {}", new Object[]{data.getInstructionId(), data.getTransformId(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                }
            }
            for (BeamFnApi.Elements.Timers timer : value.getTimersList()) {
                try {
                    LogicalEndpoint key = LogicalEndpoint.timer(timer.getInstructionId(), timer.getTransformId(), timer.getTimerFamilyId());
                    CompletableFuture consumer = BeamFnDataGrpcMultiplexer.this.receiverFuture(key);
                    if (!consumer.isDone()) {
                        LOG.debug("Received data for key {} without consumer ready. Waiting for consumer to be registered.", (Object)key);
                    }
                    ((BiConsumer)consumer.get()).accept(timer.getTimers(), timer.getIsLast());
                    if (!timer.getIsLast()) continue;
                    BeamFnDataGrpcMultiplexer.this.consumers.remove(key);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Client interrupted during handling of timer for instruction {}, transform {}, and timer family {}", new Object[]{timer.getInstructionId(), timer.getTransformId(), timer.getTimerFamilyId(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                }
                catch (RuntimeException e) {
                    LOG.error("Client failed to handle timer for instruction {}, transform {}, and timer family {}", new Object[]{timer.getInstructionId(), timer.getTransformId(), timer.getTimerFamilyId(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                }
            }
        }

        public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
            LOG.error("Failed to handle for {}", (Object)(BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor == null ? "unknown endpoint" : BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor), (Object)t);
        }

        public void onCompleted() {
            LOG.warn("Hanged up for {}.", (Object)(BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor == null ? "unknown endpoint" : BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor));
        }
    }
}

