/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.windowing;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.fn.windowing.AutoValue_EncodedBoundedWindow;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@AutoValue
public abstract class EncodedBoundedWindow
extends BoundedWindow {
    public static @UnknownKeyFor @NonNull @Initialized EncodedBoundedWindow forEncoding(@UnknownKeyFor @NonNull @Initialized ByteString encodedWindow) {
        return new AutoValue_EncodedBoundedWindow(encodedWindow);
    }

    public abstract @UnknownKeyFor @NonNull @Initialized ByteString getEncodedWindow();

    public @UnknownKeyFor @NonNull @Initialized Instant maxTimestamp() {
        throw new UnsupportedOperationException("TODO: Add support for reading the timestamp from the encoded window.");
    }

    public static class Coder
    extends AtomicCoder<EncodedBoundedWindow> {
        public static final @UnknownKeyFor @NonNull @Initialized Coder INSTANCE = new Coder();

        private Coder() {
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized EncodedBoundedWindow value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            VarInt.encode((int)value.getEncodedWindow().size(), (OutputStream)outStream);
            value.getEncodedWindow().writeTo(outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized EncodedBoundedWindow decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            int size = VarInt.decodeInt((InputStream)inStream);
            ByteString encodedWindow = ByteString.readFrom((InputStream)ByteStreams.limit((InputStream)inStream, (long)size));
            return EncodedBoundedWindow.forEncoding(encodedWindow);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized EncodedBoundedWindow value) {
            return true;
        }

        protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized EncodedBoundedWindow value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return (long)VarInt.getLength((int)value.getEncodedWindow().size()) + (long)value.getEncodedWindow().size();
        }
    }
}

