/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import org.apache.beam.repackaged.beam_sdks_java_fn_execution.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_fn_execution.com.google.common.io.ByteStreams;
import org.apache.beam.repackaged.beam_sdks_java_fn_execution.com.google.common.io.CountingInputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.vendor.grpc.v1_13_1.com.google.protobuf.ByteString;

public class DataStreams {
    public static final int DEFAULT_OUTBOUND_BUFFER_LIMIT_BYTES = 1000000;

    public static InputStream inbound(Iterator<ByteString> bytes) {
        return new Inbound(bytes);
    }

    public static ElementDelimitedOutputStream outbound(OutputChunkConsumer<ByteString> consumer) {
        return DataStreams.outbound(consumer, 1000000);
    }

    public static ElementDelimitedOutputStream outbound(OutputChunkConsumer<ByteString> consumer, int maximumChunkSize) {
        return new ElementDelimitedOutputStream(consumer, maximumChunkSize);
    }

    public static class BlockingQueueIterator<T>
    implements AutoCloseable,
    Iterator<T> {
        private static final Object POISION_PILL = new Object();
        private final BlockingQueue<T> queue;
        private T currentElement;

        public BlockingQueueIterator(BlockingQueue<T> queue) {
            this.queue = queue;
        }

        @Override
        public void close() throws Exception {
            this.queue.put(POISION_PILL);
        }

        public void accept(T t) throws Exception {
            this.queue.put(t);
        }

        @Override
        public boolean hasNext() {
            if (this.currentElement == null) {
                try {
                    this.currentElement = this.queue.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
            }
            return this.currentElement != POISION_PILL;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T rval = this.currentElement;
            this.currentElement = null;
            return rval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DataStreamDecoder<T>
    implements Iterator<T> {
        private final CountingInputStream countingInputStream;
        private final PushbackInputStream pushbackInputStream;
        private final Coder<T> coder;
        private State currentState = State.READ_REQUIRED;
        private T next;

        public DataStreamDecoder(Coder<T> coder, InputStream inputStream) {
            this.coder = coder;
            this.pushbackInputStream = new PushbackInputStream(inputStream, 1);
            this.countingInputStream = new CountingInputStream(this.pushbackInputStream);
        }

        @Override
        public boolean hasNext() {
            switch (this.currentState) {
                case EOF: {
                    return false;
                }
                case READ_REQUIRED: {
                    try {
                        int nextByte = this.pushbackInputStream.read();
                        if (nextByte == -1) {
                            this.currentState = State.EOF;
                            return false;
                        }
                        this.pushbackInputStream.unread(nextByte);
                        long count = this.countingInputStream.getCount();
                        this.next = this.coder.decode((InputStream)this.countingInputStream);
                        if (this.countingInputStream.getCount() - count == 0L) {
                            Preconditions.checkState(this.countingInputStream.read() != -1, "Unexpected EOF reached");
                        }
                        this.currentState = State.HAS_NEXT;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    return true;
                }
                case HAS_NEXT: {
                    return true;
                }
            }
            throw new IllegalStateException(String.format("Unknown state %s", new Object[]{this.currentState}));
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentState = State.READ_REQUIRED;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static enum State {
            READ_REQUIRED,
            HAS_NEXT,
            EOF;

        }
    }

    private static class Inbound<T>
    extends InputStream {
        private static final InputStream EMPTY_STREAM = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        private final Iterator<ByteString> bytes;
        private InputStream currentStream = EMPTY_STREAM;

        public Inbound(Iterator<ByteString> bytes) {
            this.bytes = bytes;
        }

        @Override
        public int read() throws IOException {
            int rval = -1;
            while ((rval = this.currentStream.read()) == -1 && this.bytes.hasNext()) {
                this.currentStream = this.bytes.next().newInput();
            }
            return rval;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int remainingLen = len;
            while ((remainingLen -= ByteStreams.read(this.currentStream, b, off + len - remainingLen, remainingLen)) > 0) {
                if (this.bytes.hasNext()) {
                    this.currentStream = this.bytes.next().newInput();
                    continue;
                }
                int bytesRead = len - remainingLen;
                return bytesRead > 0 ? bytesRead : -1;
            }
            return len - remainingLen;
        }
    }

    public static interface OutputChunkConsumer<T> {
        public void read(T var1) throws IOException;
    }

    public static final class ElementDelimitedOutputStream
    extends OutputStream {
        private final OutputChunkConsumer<ByteString> consumer;
        private final ByteString.Output output;
        private final int maximumChunkSize;
        int previousPosition;

        public ElementDelimitedOutputStream(OutputChunkConsumer<ByteString> consumer, int maximumChunkSize) {
            this.consumer = consumer;
            this.maximumChunkSize = maximumChunkSize;
            this.output = ByteString.newOutput((int)maximumChunkSize);
        }

        public void delimitElement() throws IOException {
            if (this.previousPosition == this.output.size()) {
                this.write(0);
            }
            this.previousPosition = this.output.size();
        }

        @Override
        public void write(int i) throws IOException {
            this.output.write(i);
            if (this.maximumChunkSize == this.output.size()) {
                this.internalFlush();
            }
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            int spaceRemaining = this.maximumChunkSize - this.output.size();
            if (length > spaceRemaining) {
                this.output.write(b, offset, spaceRemaining);
                offset += spaceRemaining;
                length -= spaceRemaining;
                this.internalFlush();
            }
            while (length > this.maximumChunkSize) {
                this.output.write(b, offset, this.maximumChunkSize);
                offset += this.maximumChunkSize;
                length -= this.maximumChunkSize;
                this.internalFlush();
            }
            this.output.write(b, offset, length);
        }

        @Override
        public void close() throws IOException {
            if (this.output.size() > 0) {
                this.consumer.read(this.output.toByteString());
            }
            this.output.close();
        }

        private void internalFlush() throws IOException {
            this.consumer.read(this.output.toByteString());
            this.output.reset();
            this.previousPosition = -1;
        }
    }
}

