/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.ClientProto;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.util.CredentialAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.util.Durations;
import com.google.storage.v2.StorageGrpc;
import com.google.storage.v2.StorageProto;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.alts.GoogleDefaultChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.stub.AbstractStub;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

class StorageStubProvider {
    private static final double GRPC_MAX_RETRY_ATTEMPTS = 10.0;
    private static final ImmutableSet<Status.Code> STUB_BROKEN_ERROR_CODES = ImmutableSet.of(Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE);
    private static final String DEFAULT_GCS_GRPC_SERVER_ADDRESS = StorageProto.getDescriptor().findServiceByName("Storage").getOptions().getExtension(ClientProto.defaultHost);
    private final GoogleCloudStorageReadOptions readOptions;
    private final String userAgent;
    private final ExecutorService backgroundTasksThreadPool;
    private final GrpcDecorator grpcDecorator;
    private ManagedChannel channel;

    @VisibleForTesting
    GrpcDecorator getGrpcDecorator() {
        return this.grpcDecorator;
    }

    StorageStubProvider(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, GrpcDecorator grpcDecorator) {
        this.readOptions = options.getReadChannelOptions();
        this.userAgent = options.getAppName();
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
        this.grpcDecorator = Preconditions.checkNotNull(grpcDecorator, "grpcDecorator cannot be null");
    }

    private ManagedChannel buildManagedChannel() {
        String target = Strings.isNullOrEmpty(this.readOptions.getGrpcServerAddress()) ? DEFAULT_GCS_GRPC_SERVER_ADDRESS : this.readOptions.getGrpcServerAddress();
        ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)this.grpcDecorator.createChannelBuilder(target).enableRetry()).userAgent(this.userAgent)).build();
        return channel;
    }

    public static boolean isStubBroken(Status.Code statusCode) {
        return STUB_BROKEN_ERROR_CODES.contains((Object)statusCode);
    }

    public StorageGrpc.StorageBlockingStub newBlockingStub() {
        StorageGrpc.StorageBlockingStub stub = StorageGrpc.newBlockingStub(this.getManagedChannel());
        return (StorageGrpc.StorageBlockingStub)this.grpcDecorator.applyCallOption(stub);
    }

    public StorageGrpc.StorageStub newAsyncStub() {
        StorageGrpc.StorageStub stub = (StorageGrpc.StorageStub)StorageGrpc.newStub(this.getManagedChannel()).withExecutor(this.backgroundTasksThreadPool);
        return (StorageGrpc.StorageStub)this.grpcDecorator.applyCallOption(stub);
    }

    private synchronized ManagedChannel getManagedChannel() {
        if (this.channel == null) {
            this.channel = this.buildManagedChannel();
        }
        return this.channel;
    }

    public void shutdown() {
        this.channel.shutdownNow();
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credential credential) {
        boolean useDirectpath = options.isDirectPathPreffered() && credential != null && Objects.equals(credential.getTokenServerEncodedUrl(), ComputeCredential.TOKEN_SERVER_ENCODED_URL);
        return new StorageStubProvider(options, backgroundTasksThreadPool, useDirectpath ? new DirectPathGrpcDecorator(options.getReadChannelOptions()) : new CloudPathGrpcDecorator(new CredentialAdapter(credential)));
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credentials credentials) {
        boolean useDirectpath = options.isDirectPathPreffered() && credentials instanceof ComputeEngineCredentials;
        return new StorageStubProvider(options, backgroundTasksThreadPool, useDirectpath ? new DirectPathGrpcDecorator(options.getReadChannelOptions()) : new CloudPathGrpcDecorator(credentials));
    }

    static class DirectPathGrpcDecorator
    implements GrpcDecorator {
        private final GoogleCloudStorageReadOptions readOptions;

        DirectPathGrpcDecorator(GoogleCloudStorageReadOptions readOptions) {
            this.readOptions = readOptions;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return GoogleDefaultChannelBuilder.forTarget(target).defaultServiceConfig((Map)this.getGrpcServiceConfig());
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub;
        }

        private Map<String, Object> getGrpcServiceConfig() {
            ImmutableMap<String, String> name = ImmutableMap.of("service", "google.storage.v1.Storage");
            ImmutableMap<String, ImmutableList<String>> retryPolicy = ImmutableMap.builder().put("maxAttempts", 10.0).put("initialBackoff", (Double)((Object)Durations.toString(Durations.fromMillis(this.readOptions.getBackoffInitialIntervalMillis())))).put("maxBackoff", (Double)((Object)Durations.toString(Durations.fromMillis(this.readOptions.getBackoffMaxIntervalMillis())))).put("backoffMultiplier", this.readOptions.getBackoffMultiplier()).put("retryableStatusCodes", (Double)((Object)ImmutableList.of("UNAVAILABLE", "RESOURCE_EXHAUSTED"))).build();
            ImmutableMap<String, ImmutableMap<String, ImmutableList<String>>> methodConfig = ImmutableMap.of("name", ImmutableList.of(name), "retryPolicy", retryPolicy);
            ImmutableMap childLbStrategy = ImmutableMap.of("round_robin", ImmutableMap.of());
            ImmutableMap childPolicy = ImmutableMap.of("childPolicy", ImmutableList.of(childLbStrategy));
            ImmutableMap grpcLbPolicy = ImmutableMap.of("grpclb", childPolicy);
            return ImmutableMap.of("methodConfig", ImmutableList.of(methodConfig), "loadBalancingConfig", ImmutableList.of(grpcLbPolicy));
        }
    }

    static class CloudPathGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        CloudPathGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return ManagedChannelBuilder.forTarget(target);
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub.withCallCredentials(MoreCallCredentials.from(this.credentials));
        }
    }

    static interface GrpcDecorator {
        public ManagedChannelBuilder<?> createChannelBuilder(String var1);

        public AbstractStub<?> applyCallOption(AbstractStub<?> var1);
    }
}

