/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;

final class AutoValue_AsyncWriteChannelOptions
extends AsyncWriteChannelOptions {
    private final int bufferSize;
    private final int pipeBufferSize;
    private final AsyncWriteChannelOptions.PipeType pipeType;
    private final int uploadChunkSize;
    private final int uploadCacheSize;
    private final boolean directUploadEnabled;
    private final boolean grpcChecksumsEnabled;
    private final long grpcWriteTimeout;
    private final long numberOfBufferedRequests;

    private AutoValue_AsyncWriteChannelOptions(int bufferSize, int pipeBufferSize, AsyncWriteChannelOptions.PipeType pipeType, int uploadChunkSize, int uploadCacheSize, boolean directUploadEnabled, boolean grpcChecksumsEnabled, long grpcWriteTimeout, long numberOfBufferedRequests) {
        this.bufferSize = bufferSize;
        this.pipeBufferSize = pipeBufferSize;
        this.pipeType = pipeType;
        this.uploadChunkSize = uploadChunkSize;
        this.uploadCacheSize = uploadCacheSize;
        this.directUploadEnabled = directUploadEnabled;
        this.grpcChecksumsEnabled = grpcChecksumsEnabled;
        this.grpcWriteTimeout = grpcWriteTimeout;
        this.numberOfBufferedRequests = numberOfBufferedRequests;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public int getPipeBufferSize() {
        return this.pipeBufferSize;
    }

    @Override
    public AsyncWriteChannelOptions.PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public int getUploadChunkSize() {
        return this.uploadChunkSize;
    }

    @Override
    public int getUploadCacheSize() {
        return this.uploadCacheSize;
    }

    @Override
    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    @Override
    public boolean isGrpcChecksumsEnabled() {
        return this.grpcChecksumsEnabled;
    }

    @Override
    public long getGrpcWriteTimeout() {
        return this.grpcWriteTimeout;
    }

    @Override
    public long getNumberOfBufferedRequests() {
        return this.numberOfBufferedRequests;
    }

    public String toString() {
        return "AsyncWriteChannelOptions{bufferSize=" + this.bufferSize + ", pipeBufferSize=" + this.pipeBufferSize + ", pipeType=" + (Object)((Object)this.pipeType) + ", uploadChunkSize=" + this.uploadChunkSize + ", uploadCacheSize=" + this.uploadCacheSize + ", directUploadEnabled=" + this.directUploadEnabled + ", grpcChecksumsEnabled=" + this.grpcChecksumsEnabled + ", grpcWriteTimeout=" + this.grpcWriteTimeout + ", numberOfBufferedRequests=" + this.numberOfBufferedRequests + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AsyncWriteChannelOptions) {
            AsyncWriteChannelOptions that = (AsyncWriteChannelOptions)o;
            return this.bufferSize == that.getBufferSize() && this.pipeBufferSize == that.getPipeBufferSize() && this.pipeType.equals((Object)that.getPipeType()) && this.uploadChunkSize == that.getUploadChunkSize() && this.uploadCacheSize == that.getUploadCacheSize() && this.directUploadEnabled == that.isDirectUploadEnabled() && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled() && this.grpcWriteTimeout == that.getGrpcWriteTimeout() && this.numberOfBufferedRequests == that.getNumberOfBufferedRequests();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bufferSize;
        h$ *= 1000003;
        h$ ^= this.pipeBufferSize;
        h$ *= 1000003;
        h$ ^= this.pipeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.uploadChunkSize;
        h$ *= 1000003;
        h$ ^= this.uploadCacheSize;
        h$ *= 1000003;
        h$ ^= this.directUploadEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.grpcChecksumsEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.grpcWriteTimeout >>> 32 ^ this.grpcWriteTimeout);
        h$ *= 1000003;
        return h$ ^= (int)(this.numberOfBufferedRequests >>> 32 ^ this.numberOfBufferedRequests);
    }

    @Override
    public AsyncWriteChannelOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AsyncWriteChannelOptions.Builder {
        private Integer bufferSize;
        private Integer pipeBufferSize;
        private AsyncWriteChannelOptions.PipeType pipeType;
        private Integer uploadChunkSize;
        private Integer uploadCacheSize;
        private Boolean directUploadEnabled;
        private Boolean grpcChecksumsEnabled;
        private Long grpcWriteTimeout;
        private Long numberOfBufferedRequests;

        Builder() {
        }

        private Builder(AsyncWriteChannelOptions source) {
            this.bufferSize = source.getBufferSize();
            this.pipeBufferSize = source.getPipeBufferSize();
            this.pipeType = source.getPipeType();
            this.uploadChunkSize = source.getUploadChunkSize();
            this.uploadCacheSize = source.getUploadCacheSize();
            this.directUploadEnabled = source.isDirectUploadEnabled();
            this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
            this.grpcWriteTimeout = source.getGrpcWriteTimeout();
            this.numberOfBufferedRequests = source.getNumberOfBufferedRequests();
        }

        @Override
        public AsyncWriteChannelOptions.Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPipeBufferSize(int pipeBufferSize) {
            this.pipeBufferSize = pipeBufferSize;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPipeType(AsyncWriteChannelOptions.PipeType pipeType) {
            if (pipeType == null) {
                throw new NullPointerException("Null pipeType");
            }
            this.pipeType = pipeType;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadChunkSize(int uploadChunkSize) {
            this.uploadChunkSize = uploadChunkSize;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadCacheSize(int uploadCacheSize) {
            this.uploadCacheSize = uploadCacheSize;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setDirectUploadEnabled(boolean directUploadEnabled) {
            this.directUploadEnabled = directUploadEnabled;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
            this.grpcChecksumsEnabled = grpcChecksumsEnabled;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setGrpcWriteTimeout(long grpcWriteTimeout) {
            this.grpcWriteTimeout = grpcWriteTimeout;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setNumberOfBufferedRequests(long numberOfBufferedRequests) {
            this.numberOfBufferedRequests = numberOfBufferedRequests;
            return this;
        }

        @Override
        AsyncWriteChannelOptions autoBuild() {
            if (this.bufferSize == null || this.pipeBufferSize == null || this.pipeType == null || this.uploadChunkSize == null || this.uploadCacheSize == null || this.directUploadEnabled == null || this.grpcChecksumsEnabled == null || this.grpcWriteTimeout == null || this.numberOfBufferedRequests == null) {
                StringBuilder missing = new StringBuilder();
                if (this.bufferSize == null) {
                    missing.append(" bufferSize");
                }
                if (this.pipeBufferSize == null) {
                    missing.append(" pipeBufferSize");
                }
                if (this.pipeType == null) {
                    missing.append(" pipeType");
                }
                if (this.uploadChunkSize == null) {
                    missing.append(" uploadChunkSize");
                }
                if (this.uploadCacheSize == null) {
                    missing.append(" uploadCacheSize");
                }
                if (this.directUploadEnabled == null) {
                    missing.append(" directUploadEnabled");
                }
                if (this.grpcChecksumsEnabled == null) {
                    missing.append(" grpcChecksumsEnabled");
                }
                if (this.grpcWriteTimeout == null) {
                    missing.append(" grpcWriteTimeout");
                }
                if (this.numberOfBufferedRequests == null) {
                    missing.append(" numberOfBufferedRequests");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AsyncWriteChannelOptions(this.bufferSize, this.pipeBufferSize, this.pipeType, this.uploadChunkSize, this.uploadCacheSize, this.directUploadEnabled, this.grpcChecksumsEnabled, this.grpcWriteTimeout, this.numberOfBufferedRequests);
        }
    }
}

