/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;

public class LoggingMediaHttpUploaderProgressListener
implements MediaHttpUploaderProgressListener {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final double BYTES_IN_MB = 1048576.0;
    private final long minLoggingInterval;
    private final String name;
    private long startTime;
    private long prevTime;
    private long prevUploadedBytes;

    public LoggingMediaHttpUploaderProgressListener(String name, long minLoggingInterval) {
        this.name = name;
        this.minLoggingInterval = minLoggingInterval;
    }

    @Override
    public void progressChanged(MediaHttpUploader uploader) throws IOException {
        this.progressChanged(uploader.getUploadState(), uploader.getNumBytesUploaded(), System.currentTimeMillis());
    }

    @VisibleForTesting
    void progressChanged(MediaHttpUploader.UploadState uploadState, long bytesUploaded, long currentTime) {
        switch (uploadState) {
            case INITIATION_STARTED: {
                this.startTime = currentTime;
                this.prevTime = currentTime;
                ((GoogleLogger.Api)logger.atFine()).log("Uploading: %s", this.name);
                break;
            }
            case MEDIA_IN_PROGRESS: {
                if (currentTime <= this.prevTime + this.minLoggingInterval) break;
                if (((GoogleLogger.Api)logger.atFine()).isEnabled()) {
                    double megaBytesUploaded = (double)bytesUploaded / 1048576.0;
                    double averageRate = megaBytesUploaded / ((double)(currentTime - this.startTime) / 1000.0);
                    double currentRate = (double)(bytesUploaded - this.prevUploadedBytes) / 1048576.0 / ((double)(currentTime - this.prevTime) / 1000.0);
                    ((GoogleLogger.Api)logger.atFine()).log("Uploading: %s Average Rate: %.3f MiB/s, Current Rate: %.3f MiB/s, Total: %.3f MiB", this.name, averageRate, currentRate, megaBytesUploaded);
                }
                this.prevTime = currentTime;
                this.prevUploadedBytes = bytesUploaded;
                break;
            }
            case MEDIA_COMPLETE: {
                ((GoogleLogger.Api)logger.atFine()).log("Finished Uploading: %s", this.name);
                break;
            }
        }
    }
}

