/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.io.IOException;
import java.util.Map;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class FlattenRunner<InputT> {

    static class Factory<InputT>
    implements PTransformRunnerFactory<FlattenRunner<InputT>> {
        Factory() {
        }

        @Override
        public FlattenRunner<InputT> createRunnerForPTransform(PTransformRunnerFactory.Context context) throws IOException {
            String output = Iterables.getOnlyElement(context.getPTransform().getOutputsMap().values());
            FnDataReceiver receiver = context.getPCollectionConsumer(output);
            RehydratedComponents components = RehydratedComponents.forComponents(RunnerApi.Components.newBuilder().putAllCoders(context.getCoders()).build());
            FlattenRunner runner = new FlattenRunner();
            for (String pCollectionId : context.getPTransform().getInputsMap().values()) {
                context.addPCollectionConsumer(pCollectionId, receiver, this.getValueCoder(components, context.getPCollections(), pCollectionId));
            }
            return runner;
        }

        private Coder<?> getValueCoder(RehydratedComponents components, Map<String, RunnerApi.PCollection> pCollections, String pCollectionId) throws IOException {
            if (!pCollections.containsKey(pCollectionId)) {
                throw new IllegalArgumentException(String.format("Missing PCollection for id: %s", pCollectionId));
            }
            Coder<Object> coder = components.getCoder(pCollections.get(pCollectionId).getCoderId());
            if (coder instanceof WindowedValue.WindowedValueCoder) {
                coder = ((WindowedValue.WindowedValueCoder)coder).getValueCoder();
            }
            return coder;
        }
    }

    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public Map<String, PTransformRunnerFactory> getPTransformRunnerFactories() {
            return ImmutableMap.of("beam:transform:flatten:v1", new Factory());
        }
    }
}

