/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.control.BundleSplitListener;
import org.apache.beam.fn.harness.data.BeamFnDataClient;
import org.apache.beam.fn.harness.data.BeamFnTimerClient;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.function.ThrowingRunnable;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.WindowedValue;

public interface PTransformRunnerFactory<T> {
    public T createRunnerForPTransform(Context var1) throws IOException;

    @FunctionalInterface
    public static interface ProgressRequestCallback {
        public List<MetricsApi.MonitoringInfo> getMonitoringInfos() throws Exception;
    }

    public static interface Registrar {
        public Map<String, PTransformRunnerFactory> getPTransformRunnerFactories();
    }

    public static interface Context {
        public PipelineOptions getPipelineOptions();

        public BeamFnDataClient getBeamFnDataClient();

        public BeamFnStateClient getBeamFnStateClient();

        public BeamFnTimerClient getBeamFnTimerClient();

        public String getPTransformId();

        public RunnerApi.PTransform getPTransform();

        public Supplier<String> getProcessBundleInstructionIdSupplier();

        public Supplier<List<BeamFnApi.ProcessBundleRequest.CacheToken>> getCacheTokensSupplier();

        public Supplier<Cache<?, ?>> getBundleCacheSupplier();

        public Cache<?, ?> getProcessWideCache();

        public Map<String, RunnerApi.PCollection> getPCollections();

        public Map<String, RunnerApi.Coder> getCoders();

        public Map<String, RunnerApi.WindowingStrategy> getWindowingStrategies();

        public <T> void addPCollectionConsumer(String var1, FnDataReceiver<WindowedValue<T>> var2, Coder<T> var3);

        public <T> FnDataReceiver<T> getPCollectionConsumer(String var1);

        public void addStartBundleFunction(ThrowingRunnable var1);

        public void addFinishBundleFunction(ThrowingRunnable var1);

        public <T> void addIncomingDataEndpoint(Endpoints.ApiServiceDescriptor var1, Coder<T> var2, FnDataReceiver<T> var3);

        public <T> void addIncomingTimerEndpoint(String var1, Coder<Timer<T>> var2, FnDataReceiver<Timer<T>> var3);

        public void addResetFunction(ThrowingRunnable var1);

        public void addTearDownFunction(ThrowingRunnable var1);

        public void addProgressRequestCallback(ProgressRequestCallback var1);

        public BundleSplitListener getSplitListener();

        public DoFn.BundleFinalizer getBundleFinalizer();
    }
}

