/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.io.IOException;
import java.util.Map;
import org.apache.beam.fn.harness.MapFnRunners;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class WindowMappingFnRunner {
    static final String URN = "beam:transform:map_windows:v1";

    static <T, W1 extends BoundedWindow, W2 extends BoundedWindow> ThrowingFunction<KV<T, W1>, KV<T, W2>> createMapFunctionForPTransform(String ptransformId, RunnerApi.PTransform pTransform) throws IOException {
        RunnerApi.FunctionSpec windowMappingFnPayload = RunnerApi.FunctionSpec.parseFrom(pTransform.getSpec().getPayload());
        WindowMappingFn<?> windowMappingFn = PCollectionViewTranslation.windowMappingFnFromProto(windowMappingFnPayload);
        return input -> KV.of(input.getKey(), windowMappingFn.getSideInputWindow((BoundedWindow)input.getValue()));
    }

    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public Map<String, PTransformRunnerFactory> getPTransformRunnerFactories() {
            return ImmutableMap.of(WindowMappingFnRunner.URN, MapFnRunners.forValueMapFnFactory(WindowMappingFnRunner::createMapFunctionForPTransform));
        }
    }
}

