/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.data;

import org.apache.beam.fn.harness.data.BeamFnDataClient;
import org.apache.beam.fn.harness.data.BeamFnTimerClient;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class BeamFnTimerGrpcClient
implements BeamFnTimerClient {
    private final BeamFnDataClient beamFnDataClient;
    private final Endpoints.ApiServiceDescriptor timerApiServiceDescriptor;

    public BeamFnTimerGrpcClient(BeamFnDataClient beamFnDataClient, Endpoints.ApiServiceDescriptor timerApiServiceDescriptor) {
        this.beamFnDataClient = beamFnDataClient;
        this.timerApiServiceDescriptor = timerApiServiceDescriptor;
    }

    @Override
    public <K> CloseableFnDataReceiver<Timer<K>> register(LogicalEndpoint timerEndpoint, Coder<Timer<K>> coder) {
        Preconditions.checkArgument(timerEndpoint.isTimer(), "Expected to receive timer endpoint but received %s", (Object)timerEndpoint);
        return this.beamFnDataClient.send(this.timerApiServiceDescriptor, timerEndpoint, coder);
    }
}

