/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.stream.PrefetchableIterable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterables;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class BagUserState<T> {
    private final Cache<?, ?> cache;
    private final BeamFnStateClient beamFnStateClient;
    private final BeamFnApi.StateRequest request;
    private final Coder<T> valueCoder;
    private final StateFetchingIterators.CachingStateIterable<T> oldValues;
    private List<T> newValues;
    private boolean isCleared;
    private boolean isClosed;

    public BagUserState(Cache<?, ?> cache, BeamFnStateClient beamFnStateClient, String instructionId, BeamFnApi.StateKey stateKey, Coder<T> valueCoder) {
        Preconditions.checkArgument(stateKey.hasBagUserState(), "Expected BagUserState StateKey but received %s.", (Object)stateKey);
        this.cache = cache;
        this.beamFnStateClient = beamFnStateClient;
        this.valueCoder = valueCoder;
        this.request = BeamFnApi.StateRequest.newBuilder().setInstructionId(instructionId).setStateKey(stateKey).build();
        this.oldValues = StateFetchingIterators.readAllAndDecodeStartingFrom(this.cache, beamFnStateClient, this.request, valueCoder);
        this.newValues = new ArrayList<T>();
    }

    public PrefetchableIterable<T> get() {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        if (this.isCleared) {
            return PrefetchableIterables.limit(Collections.unmodifiableList(this.newValues), this.newValues.size());
        }
        if (this.newValues.isEmpty()) {
            return this.oldValues;
        }
        return PrefetchableIterables.concat(this.oldValues, Iterables.limit(Collections.unmodifiableList(this.newValues), this.newValues.size()));
    }

    public void append(T t) {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.newValues.add(t);
    }

    public void clear() {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.isCleared = true;
        this.newValues = new ArrayList<T>();
    }

    public void asyncClose() throws Exception {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.isClosed = true;
        if (!this.isCleared && this.newValues.isEmpty()) {
            return;
        }
        if (this.isCleared) {
            this.beamFnStateClient.handle(this.request.toBuilder().setClear(BeamFnApi.StateClearRequest.getDefaultInstance()));
        }
        if (!this.newValues.isEmpty()) {
            ByteString.Output out = ByteString.newOutput();
            for (T newValue : this.newValues) {
                this.valueCoder.encode(newValue, out);
            }
            this.beamFnStateClient.handle(this.request.toBuilder().setAppend(BeamFnApi.StateAppendRequest.newBuilder().setData(out.toByteString())));
        }
        if (this.isCleared) {
            this.oldValues.clearAndAppend(this.newValues);
        } else {
            this.oldValues.append(this.newValues);
        }
    }
}

