/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class IterableSideInput<T>
implements Materializations.IterableView<T> {
    private final Iterable<T> values;

    public IterableSideInput(Cache<?, ?> cache, BeamFnStateClient beamFnStateClient, String instructionId, BeamFnApi.StateKey stateKey, Coder<T> valueCoder) {
        Preconditions.checkArgument(stateKey.hasIterableSideInput(), "Expected IterableSideInput StateKey but received %s.", (Object)stateKey);
        this.values = StateFetchingIterators.readAllAndDecodeStartingFrom(cache, beamFnStateClient, BeamFnApi.StateRequest.newBuilder().setInstructionId(instructionId).setStateKey(stateKey).build(), valueCoder);
    }

    @Override
    public Iterable<T> get() {
        return this.values;
    }
}

