/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.stream;

import java.util.List;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;

public abstract class HarnessStreamObserverFactories {
    public static OutboundObserverFactory fromOptions(PipelineOptions options) {
        List<String> experiments = options.as(ExperimentalOptions.class).getExperiments();
        if (experiments != null && experiments.contains("beam_fn_api_buffered_stream")) {
            int bufferSize = HarnessStreamObserverFactories.getBufferSize(experiments);
            if (bufferSize > 0) {
                return OutboundObserverFactory.clientBuffered(options.as(GcsOptions.class).getExecutorService(), bufferSize);
            }
            return OutboundObserverFactory.clientBuffered(options.as(GcsOptions.class).getExecutorService());
        }
        return OutboundObserverFactory.clientDirect();
    }

    private static int getBufferSize(List<String> experiments) {
        for (String experiment : experiments) {
            if (!experiment.startsWith("beam_fn_api_buffered_stream_buffer_size=")) continue;
            return Integer.parseInt(experiment.substring("beam_fn_api_buffered_stream_buffer_size=".length()));
        }
        return -1;
    }
}

