/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.ArtifactResolver;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;

public class DefaultArtifactResolver
implements ArtifactResolver {
    public static final ArtifactResolver INSTANCE = new DefaultArtifactResolver();
    private List<ArtifactResolver.ResolutionFn> fns = Lists.newArrayList(info -> {
        if (BeamUrns.getUrn(RunnerApi.StandardArtifacts.Types.FILE).equals(info.getTypeUrn())) {
            return Optional.of(ImmutableList.of(info));
        }
        return Optional.empty();
    });
    private Function<RunnerApi.ArtifactInformation, Stream<RunnerApi.ArtifactInformation>> resolver = info -> {
        for (ArtifactResolver.ResolutionFn fn : Lists.reverse(this.regesteredFns())) {
            Optional<List<RunnerApi.ArtifactInformation>> resolved = fn.resolve((RunnerApi.ArtifactInformation)info);
            if (!resolved.isPresent()) continue;
            return resolved.get().stream();
        }
        throw new RuntimeException(String.format("Cannot resolve artifact information: %s", info));
    };

    private synchronized List<ArtifactResolver.ResolutionFn> regesteredFns() {
        return ImmutableList.copyOf(this.fns);
    }

    @Override
    public synchronized void register(ArtifactResolver.ResolutionFn fn) {
        this.fns.add(fn);
    }

    @Override
    public List<RunnerApi.ArtifactInformation> resolveArtifacts(List<RunnerApi.ArtifactInformation> artifacts) {
        for (ArtifactResolver.ResolutionFn fn : Lists.reverse(this.regesteredFns())) {
            ArrayList<RunnerApi.ArtifactInformation> moreResolved = new ArrayList<RunnerApi.ArtifactInformation>();
            for (RunnerApi.ArtifactInformation artifact : artifacts) {
                Optional<List<RunnerApi.ArtifactInformation>> resolved = fn.resolve(artifact);
                if (resolved.isPresent()) {
                    moreResolved.addAll((Collection<RunnerApi.ArtifactInformation>)resolved.get());
                    continue;
                }
                moreResolved.add(artifact);
            }
            artifacts = moreResolved;
        }
        return artifacts;
    }

    @Override
    public RunnerApi.Pipeline resolveArtifacts(RunnerApi.Pipeline pipeline) {
        ImmutableMap.Builder<String, RunnerApi.Environment> environmentMapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, RunnerApi.Environment> entry : pipeline.getComponents().getEnvironmentsMap().entrySet()) {
            List resolvedDependencies = entry.getValue().getDependenciesList().parallelStream().flatMap(this.resolver).collect(Collectors.toList());
            environmentMapBuilder.put(entry.getKey(), entry.getValue().toBuilder().clearDependencies().addAllDependencies(resolvedDependencies).build());
        }
        return pipeline.toBuilder().setComponents(pipeline.getComponents().toBuilder().putAllEnvironments(environmentMapBuilder.build())).build();
    }
}

