/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

class FieldAccessVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private final Map<PCollection<?>, FieldAccessDescriptor> pCollectionFieldAccess = new HashMap();

    FieldAccessVisitor() {
    }

    ImmutableMap<PCollection<?>, FieldAccessDescriptor> getPCollectionFieldAccess() {
        return ImmutableMap.copyOf(this.pCollectionFieldAccess);
    }

    @Override
    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        Map<PCollection<?>, FieldAccessDescriptor> currentFieldAccess = FieldAccessVisitor.getFieldAccess(node);
        for (Map.Entry<PCollection<?>, FieldAccessDescriptor> entry : currentFieldAccess.entrySet()) {
            FieldAccessDescriptor previousFieldAccess = this.pCollectionFieldAccess.get(entry.getKey());
            FieldAccessDescriptor newFieldAccess = previousFieldAccess == null ? entry.getValue() : FieldAccessDescriptor.union(ImmutableList.of(previousFieldAccess, entry.getValue()));
            this.pCollectionFieldAccess.put(entry.getKey(), newFieldAccess);
        }
    }

    private static Map<PCollection<?>, FieldAccessDescriptor> getFieldAccess(TransformHierarchy.Node node) {
        PTransform<?, ?> transform = node.getTransform();
        HashMap access = new HashMap();
        if (transform instanceof ParDo.MultiOutput) {
            Set mainInputs = node.getInputs().entrySet().stream().filter(entry -> !transform.getAdditionalInputs().containsKey(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
            PCollection mainInput = (PCollection)Iterables.getOnlyElement(mainInputs);
            DoFn fn = ((ParDo.MultiOutput)transform).getFn();
            FieldAccessDescriptor fields = ParDo.getDoFnSchemaInformation(fn, mainInput).getFieldAccessDescriptor();
            access.put(mainInput, fields);
        }
        for (PCollection<?> input : node.getInputs().values()) {
            if (access.containsKey(input)) continue;
            access.put(input, FieldAccessDescriptor.withAllFields());
        }
        return ImmutableMap.copyOf(access);
    }
}

