/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction.graph;

import com.google.auto.value.AutoValue;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.AutoValue_ImmutableExecutableStage;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.SideInputReference;
import org.apache.beam.runners.core.construction.graph.TimerReference;
import org.apache.beam.runners.core.construction.graph.UserStateReference;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

@AutoValue
public abstract class ImmutableExecutableStage
implements ExecutableStage {
    public static ImmutableExecutableStage ofFullComponents(RunnerApi.Components components, RunnerApi.Environment environment, PipelineNode.PCollectionNode input, Collection<SideInputReference> sideInputs, Collection<UserStateReference> userStates, Collection<TimerReference> timers, Collection<PipelineNode.PTransformNode> transforms, Collection<PipelineNode.PCollectionNode> outputs, Collection<RunnerApi.ExecutableStagePayload.WireCoderSetting> wireCoderSettings) {
        RunnerApi.Components prunedComponents = components.toBuilder().clearTransforms().putAllTransforms(transforms.stream().collect(Collectors.toMap(PipelineNode.PTransformNode::getId, PipelineNode.PTransformNode::getTransform))).build();
        return ImmutableExecutableStage.of(prunedComponents, environment, input, sideInputs, userStates, timers, transforms, outputs, wireCoderSettings);
    }

    public static ImmutableExecutableStage of(RunnerApi.Components components, RunnerApi.Environment environment, PipelineNode.PCollectionNode input, Collection<SideInputReference> sideInputs, Collection<UserStateReference> userStates, Collection<TimerReference> timers, Collection<PipelineNode.PTransformNode> transforms, Collection<PipelineNode.PCollectionNode> outputs, Collection<RunnerApi.ExecutableStagePayload.WireCoderSetting> wireCoderSettings) {
        return new AutoValue_ImmutableExecutableStage(components, environment, input, ImmutableSet.copyOf(sideInputs), ImmutableSet.copyOf(userStates), ImmutableSet.copyOf(timers), ImmutableSet.copyOf(transforms), ImmutableSet.copyOf(outputs), wireCoderSettings);
    }

    @Override
    public abstract RunnerApi.Components getComponents();

    @Override
    public abstract RunnerApi.Environment getEnvironment();

    @Override
    public abstract PipelineNode.PCollectionNode getInputPCollection();

    @Override
    public abstract Collection<SideInputReference> getSideInputs();

    @Override
    public abstract Collection<UserStateReference> getUserStates();

    @Override
    public abstract Collection<TimerReference> getTimers();

    @Override
    public abstract Collection<PipelineNode.PTransformNode> getTransforms();

    @Override
    public abstract Collection<PipelineNode.PCollectionNode> getOutputPCollections();

    @Override
    public abstract Collection<RunnerApi.ExecutableStagePayload.WireCoderSetting> getWireCoderSettings();
}

