/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction.graph;

import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ProtoOverrides {
    public static RunnerApi.Pipeline updateTransform(String urn, RunnerApi.Pipeline originalPipeline, TransformReplacement compositeBuilder) {
        RunnerApi.Components.Builder resultComponents = originalPipeline.getComponents().toBuilder();
        for (Map.Entry<String, RunnerApi.PTransform> pt : originalPipeline.getComponents().getTransformsMap().entrySet()) {
            RunnerApi.MessageWithComponents updated;
            if (pt.getValue().getSpec() == null || !urn.equals(pt.getValue().getSpec().getUrn()) || (updated = compositeBuilder.getReplacement(pt.getKey(), originalPipeline.getComponents())) == null) continue;
            Preconditions.checkArgument(updated.getPtransform().getOutputsMap().equals(pt.getValue().getOutputsMap()), "A %s must produce all of the outputs of the original %s", (Object)TransformReplacement.class.getSimpleName(), (Object)RunnerApi.PTransform.class.getSimpleName());
            ProtoOverrides.removeSubtransforms(pt.getValue(), resultComponents);
            resultComponents.mergeFrom(updated.getComponents()).putTransforms(pt.getKey(), updated.getPtransform());
        }
        return originalPipeline.toBuilder().setComponents(resultComponents).build();
    }

    private static void removeSubtransforms(RunnerApi.PTransform pt, RunnerApi.Components.Builder target) {
        for (String subtransformId : pt.getSubtransformsList()) {
            RunnerApi.PTransform subtransform = target.getTransformsOrThrow(subtransformId);
            ProtoOverrides.removeSubtransforms(subtransform, target);
            target.removeTransforms(subtransformId);
        }
    }

    @FunctionalInterface
    public static interface TransformReplacement {
        public  @Nullable RunnerApi.MessageWithComponents getReplacement(String var1, RunnerApi.ComponentsOrBuilder var2);
    }
}

