/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.state.TimeDomain;

public class DefaultTriggerStateMachine
extends TriggerStateMachine {
    private DefaultTriggerStateMachine() {
        super(null);
    }

    public static DefaultTriggerStateMachine of() {
        return new DefaultTriggerStateMachine();
    }

    @Override
    public void prefetchOnElement(TriggerStateMachine.PrefetchContext c) {
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        if (!this.endOfWindowReached(c)) {
            c.setTimer(c.window().maxTimestamp(), TimeDomain.EVENT_TIME);
        }
    }

    @Override
    public void prefetchOnMerge(TriggerStateMachine.MergingPrefetchContext c) {
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
        if (!this.endOfWindowReached(c)) {
            c.setTimer(c.window().maxTimestamp(), TimeDomain.EVENT_TIME);
        }
    }

    @Override
    public void prefetchShouldFire(TriggerStateMachine.PrefetchContext c) {
    }

    @Override
    public void clear(TriggerStateMachine.TriggerContext c) throws Exception {
    }

    @Override
    public boolean isCompatible(TriggerStateMachine other) {
        return other instanceof DefaultTriggerStateMachine;
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        return this.endOfWindowReached(context);
    }

    private boolean endOfWindowReached(TriggerStateMachine.TriggerContext context) {
        return context.currentEventTime() != null && context.currentEventTime().isAfter(context.window().maxTimestamp());
    }

    @Override
    public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
    }
}

