/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuralByteArray;
import org.apache.beam.sdk.util.ExposedByteArrayOutputStream;
import org.apache.beam.sdk.util.StreamUtils;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;

public class ByteArrayCoder
extends AtomicCoder<byte[]> {
    private static final ByteArrayCoder INSTANCE = new ByteArrayCoder();
    private static final TypeDescriptor<byte[]> TYPE_DESCRIPTOR = new TypeDescriptor<byte[]>(){};

    public static ByteArrayCoder of() {
        return INSTANCE;
    }

    private ByteArrayCoder() {
    }

    @Override
    public void encode(byte[] value, OutputStream outStream) throws IOException, CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(byte[] value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null byte[]");
        }
        if (!context.isWholeStream) {
            VarInt.encode(value.length, outStream);
            outStream.write(value);
        } else {
            outStream.write(value);
        }
    }

    public void encodeAndOwn(byte[] value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (!context.isWholeStream) {
            VarInt.encode(value.length, outStream);
            outStream.write(value);
        } else if (outStream instanceof ExposedByteArrayOutputStream) {
            ((ExposedByteArrayOutputStream)outStream).writeAndOwn(value);
        } else {
            outStream.write(value);
        }
    }

    @Override
    public byte[] decode(InputStream inStream) throws IOException, CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public byte[] decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        if (context.isWholeStream) {
            return StreamUtils.getBytesWithoutClosing(inStream);
        }
        int length = VarInt.decodeInt(inStream);
        if (length < 0) {
            throw new IOException("invalid length " + length);
        }
        byte[] value = new byte[length];
        ByteStreams.readFully(inStream, value);
        return value;
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public Object structuralValue(byte[] value) {
        return new StructuralByteArray(value);
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(byte[] value) {
        return true;
    }

    @Override
    public TypeDescriptor<byte[]> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(byte[] value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null byte[]");
        }
        return (long)VarInt.getLength(value.length) + (long)value.length;
    }
}

