/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableCoder<T extends Serializable>
extends CustomCoder<T> {
    private static final Set<Class<?>> MISSING_EQUALS_METHOD = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private static final Logger LOG = LoggerFactory.getLogger(SerializableCoder.class);
    private final Class<T> type;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient @Nullable TypeDescriptor<T> typeDescriptor;

    public static <T extends Serializable> SerializableCoder<T> of(TypeDescriptor<T> type) {
        Class<T> clazz = type.getRawType();
        return new SerializableCoder<T>(clazz, type);
    }

    @Override
    public boolean consistentWithEquals() {
        return false;
    }

    @Override
    public Object structuralValue(T value) {
        return value;
    }

    public static <T extends Serializable> SerializableCoder<T> of(Class<T> clazz) {
        SerializableCoder.checkEqualsMethodDefined(clazz);
        return new SerializableCoder<T>(clazz, TypeDescriptor.of(clazz));
    }

    private static <T extends Serializable> void checkEqualsMethodDefined(Class<T> clazz) {
        boolean warn = true;
        if (!clazz.isInterface()) {
            Method method;
            try {
                method = clazz.getMethod("equals", Object.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)String.format("Concrete class %s has no equals method", clazz));
            }
            warn = Object.class.equals(method.getDeclaringClass());
        }
        if (warn && MISSING_EQUALS_METHOD.add(clazz)) {
            LOG.warn("Can't verify serialized elements of type {} have well defined equals method. This may produce incorrect results on some {}", (Object)clazz.getSimpleName(), (Object)PipelineRunner.class.getSimpleName());
        }
    }

    public static CoderProvider getCoderProvider() {
        return new SerializableCoderProvider();
    }

    protected SerializableCoder(Class<T> type, TypeDescriptor<T> typeDescriptor) {
        this.type = type;
        this.typeDescriptor = typeDescriptor;
    }

    public Class<T> getRecordType() {
        return this.type;
    }

    @Override
    public void encode(T value, OutputStream outStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outStream);
        oos.writeObject(value);
        oos.flush();
    }

    @Override
    public T decode(InputStream inStream) throws IOException, CoderException {
        try {
            ObjectInputStream ois = new ObjectInputStream(inStream);
            return (T)((Serializable)this.type.cast(ois.readObject()));
        }
        catch (ClassNotFoundException e) {
            throw new CoderException("unable to deserialize record", e);
        }
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Java Serialization may be non-deterministic.");
    }

    public boolean equals(@Nullable Object other) {
        return other != null && this.getClass() == other.getClass() && this.type == ((SerializableCoder)other).type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public TypeDescriptor<T> getEncodedTypeDescriptor() {
        if (this.typeDescriptor == null) {
            this.typeDescriptor = TypeDescriptor.of(this.type);
        }
        return this.typeDescriptor;
    }

    public String toString() {
        return "SerializableCoder(" + this.type.getName() + ")";
    }

    static class SerializableCoderProvider
    extends CoderProvider {
        SerializableCoderProvider() {
        }

        @Override
        public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            if (Serializable.class.isAssignableFrom(typeDescriptor.getRawType())) {
                return SerializableCoder.of(typeDescriptor);
            }
            throw new CannotProvideCoderException("Cannot provide SerializableCoder because " + typeDescriptor + " does not implement Serializable");
        }
    }

    public static class SerializableCoderProviderRegistrar
    implements CoderProviderRegistrar {
        @Override
        public List<CoderProvider> getCoderProviders() {
            return ImmutableList.of(SerializableCoder.getCoderProvider());
        }
    }
}

