/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;

public class TimestampPrefixingWindowCoder<T extends BoundedWindow>
extends StructuredCoder<T> {
    private final Coder<T> windowCoder;

    public static <T extends BoundedWindow> TimestampPrefixingWindowCoder<T> of(Coder<T> windowCoder) {
        return new TimestampPrefixingWindowCoder<T>(windowCoder);
    }

    TimestampPrefixingWindowCoder(Coder<T> windowCoder) {
        this.windowCoder = windowCoder;
    }

    public Coder<T> getWindowCoder() {
        return this.windowCoder;
    }

    @Override
    public void encode(T value, OutputStream outStream) throws CoderException, IOException {
        if (value == null) {
            throw new CoderException("Cannot encode null window");
        }
        InstantCoder.of().encode(((BoundedWindow)value).maxTimestamp(), outStream);
        this.windowCoder.encode(value, outStream);
    }

    @Override
    public T decode(InputStream inStream) throws CoderException, IOException {
        InstantCoder.of().decode(inStream);
        return (T)((BoundedWindow)this.windowCoder.decode(inStream));
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Lists.newArrayList(this.windowCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.windowCoder.verifyDeterministic();
    }

    @Override
    public boolean consistentWithEquals() {
        return this.windowCoder.consistentWithEquals();
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(T value) {
        return this.windowCoder.isRegisterByteSizeObserverCheap(value);
    }

    @Override
    public void registerByteSizeObserver(T value, ElementByteSizeObserver observer) throws Exception {
        InstantCoder.of().registerByteSizeObserver(((BoundedWindow)value).maxTimestamp(), observer);
        this.windowCoder.registerByteSizeObserver(value, observer);
    }
}

