/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.auth;

import com.google.auth.Credentials;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.options.PipelineOptions;

public class NoopCredentialFactory
implements CredentialFactory {
    private static final NoopCredentialFactory INSTANCE = new NoopCredentialFactory();
    private static final NoopCredentials NOOP_CREDENTIALS = new NoopCredentials();

    public static NoopCredentialFactory fromOptions(PipelineOptions options) {
        return INSTANCE;
    }

    @Override
    public Credentials getCredential() throws IOException {
        return NOOP_CREDENTIALS;
    }

    private static class NoopCredentials
    extends Credentials {
        private NoopCredentials() {
        }

        @Override
        public String getAuthenticationType() {
            return null;
        }

        @Override
        public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
            return null;
        }

        @Override
        public boolean hasRequestMetadata() {
            return false;
        }

        @Override
        public boolean hasRequestMetadataOnly() {
            return false;
        }

        @Override
        public void refresh() throws IOException {
        }
    }
}

