/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import java.io.IOException;
import java.util.Map;
import org.apache.beam.runners.core.metrics.LabeledMetrics;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.util.HistogramData;

public class LatencyRecordingHttpRequestInitializer
implements HttpRequestInitializer {
    public static final HistogramData.BucketType HISTOGRAM_BUCKET_TYPE = HistogramData.LinearBuckets.of(0.0, 20.0, 3000);
    private final Histogram requestLatencies;

    public LatencyRecordingHttpRequestInitializer(Histogram histogram) {
        this.requestLatencies = histogram;
    }

    public LatencyRecordingHttpRequestInitializer(Map<String, String> labels) {
        this.requestLatencies = LabeledMetrics.histogram(MonitoringInfoMetricName.named(MonitoringInfoConstants.Urns.API_REQUEST_LATENCIES, labels), HISTOGRAM_BUCKET_TYPE, true);
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        LoggingInterceptor interceptor = new LoggingInterceptor(this.requestLatencies);
        request.setInterceptor(interceptor);
        request.setResponseInterceptor(interceptor);
    }

    private static class LoggingInterceptor
    implements HttpResponseInterceptor,
    HttpExecuteInterceptor {
        private final Histogram requestLatencies;
        private long startTime;

        public LoggingInterceptor(Histogram requestLatencies) {
            this.requestLatencies = requestLatencies;
        }

        @Override
        public void interceptResponse(HttpResponse response) throws IOException {
            long timeToResponse = System.currentTimeMillis() - this.startTime;
            this.requestLatencies.update(timeToResponse);
        }

        @Override
        public void intercept(HttpRequest request) throws IOException {
            this.startTime = System.currentTimeMillis();
        }
    }
}

