/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util.gcsfs;

import com.google.api.services.storage.model.StorageObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GcsPath
implements Path,
Serializable {
    public static final String SCHEME = "gs";
    public static final Pattern GCS_URI = Pattern.compile("(?<SCHEME>[^:]+)://(?<BUCKET>[^/]+)(/(?<OBJECT>.*))?");
    private static final Pattern GCS_RESOURCE_NAME = Pattern.compile("storage.googleapis.com/(?<BUCKET>[^/]+)(/(?<OBJECT>.*))?");
    private transient @Nullable FileSystem fs;
    @Nonnull
    private final String bucket;
    @Nonnull
    private final String object;

    public static GcsPath fromUri(URI uri) {
        Preconditions.checkArgument(uri.getScheme().equalsIgnoreCase(SCHEME), "URI: %s is not a GCS URI", (Object)uri);
        Preconditions.checkArgument(uri.getPort() == -1, "GCS URI may not specify port: %s (%i)", (Object)uri, uri.getPort());
        Preconditions.checkArgument(Strings.isNullOrEmpty(uri.getUserInfo()), "GCS URI may not specify userInfo: %s (%s)", (Object)uri, (Object)uri.getUserInfo());
        Preconditions.checkArgument(Strings.isNullOrEmpty(uri.getQuery()), "GCS URI may not specify query: %s (%s)", (Object)uri, (Object)uri.getQuery());
        Preconditions.checkArgument(Strings.isNullOrEmpty(uri.getFragment()), "GCS URI may not specify fragment: %s (%s)", (Object)uri, (Object)uri.getFragment());
        return GcsPath.fromUri(uri.toString());
    }

    public static GcsPath fromUri(String uri) {
        Matcher m3 = GCS_URI.matcher(uri);
        Preconditions.checkArgument(m3.matches(), "Invalid GCS URI: %s", (Object)uri);
        Preconditions.checkArgument(m3.group("SCHEME").equalsIgnoreCase(SCHEME), "URI: %s is not a GCS URI", (Object)uri);
        return new GcsPath(null, m3.group("BUCKET"), m3.group("OBJECT"));
    }

    public static GcsPath fromResourceName(String name) {
        Matcher m3 = GCS_RESOURCE_NAME.matcher(name);
        Preconditions.checkArgument(m3.matches(), "Invalid GCS resource name: %s", (Object)name);
        return new GcsPath(null, m3.group("BUCKET"), m3.group("OBJECT"));
    }

    public static GcsPath fromObject(StorageObject object) {
        return new GcsPath(null, object.getBucket(), object.getName());
    }

    public static GcsPath fromComponents(@Nullable String bucket, @Nullable String object) {
        return new GcsPath(null, bucket, object);
    }

    public GcsPath(@Nullable FileSystem fs, @Nullable String bucket, @Nullable String object) {
        if (bucket == null) {
            bucket = "";
        }
        Preconditions.checkArgument(!bucket.contains("/"), "GCS bucket may not contain a slash");
        Preconditions.checkArgument(bucket.isEmpty() || bucket.matches("[a-z0-9][-_a-z0-9.]+[a-z0-9]"), "GCS bucket names must contain only lowercase letters, numbers, dashes (-), underscores (_), and dots (.). Bucket names must start and end with a number or letter. See https://developers.google.com/storage/docs/bucketnaming for more details.  Bucket name: " + bucket);
        if (object == null) {
            object = "";
        }
        Preconditions.checkArgument(object.indexOf(10) < 0 && object.indexOf(13) < 0, "GCS object names must not contain Carriage Return or Line Feed characters.");
        this.fs = fs;
        this.bucket = bucket;
        this.object = object;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getObject() {
        return this.object;
    }

    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        return !this.bucket.isEmpty() || this.object.isEmpty();
    }

    @Override
    public GcsPath getRoot() {
        return new GcsPath(this.fs, "", "");
    }

    @Override
    public GcsPath getFileName() {
        int nameCount = this.getNameCount();
        if (nameCount < 2) {
            throw new UnsupportedOperationException("Can't get filename from root path in the bucket: " + this);
        }
        return this.getName(nameCount - 1);
    }

    @Override
    public GcsPath getParent() {
        if (this.bucket.isEmpty() && this.object.isEmpty()) {
            return null;
        }
        if (this.object.isEmpty()) {
            return this.getRoot();
        }
        int i = this.object.lastIndexOf(47, this.object.length() - 2);
        if (i <= 0) {
            if (this.bucket.isEmpty()) {
                return null;
            }
            return new GcsPath(this.fs, this.bucket, "");
        }
        return new GcsPath(this.fs, this.bucket, this.object.substring(0, i + 1));
    }

    @Override
    public int getNameCount() {
        int count;
        int n = count = this.bucket.isEmpty() ? 0 : 1;
        if (this.object.isEmpty()) {
            return count;
        }
        int index = -1;
        while ((index = this.object.indexOf(47, index + 1)) != -1) {
            ++count;
        }
        return this.object.endsWith("/") ? count : count + 1;
    }

    @Override
    public GcsPath getName(int count) {
        Preconditions.checkArgument(count >= 0);
        Iterator<Path> iterator = this.iterator();
        for (int i = 0; i < count; ++i) {
            Preconditions.checkArgument(iterator.hasNext());
            iterator.next();
        }
        Preconditions.checkArgument(iterator.hasNext());
        return (GcsPath)iterator.next();
    }

    @Override
    public GcsPath subpath(int beginIndex, int endIndex) {
        Preconditions.checkArgument(beginIndex >= 0);
        Preconditions.checkArgument(endIndex > beginIndex);
        Iterator<Path> iterator = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            Preconditions.checkArgument(iterator.hasNext());
            iterator.next();
        }
        GcsPath path = null;
        while (beginIndex < endIndex) {
            Preconditions.checkArgument(iterator.hasNext());
            path = path == null ? (GcsPath)iterator.next() : path.resolve(iterator.next());
            ++beginIndex;
        }
        return path;
    }

    @Override
    public boolean startsWith(Path other) {
        if (other instanceof GcsPath) {
            GcsPath gcsPath = (GcsPath)other;
            return this.startsWith(gcsPath.bucketAndObject());
        }
        return this.startsWith(other.toString());
    }

    @Override
    public boolean startsWith(String prefix) {
        return this.bucketAndObject().startsWith(prefix);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other instanceof GcsPath) {
            GcsPath gcsPath = (GcsPath)other;
            return this.endsWith(gcsPath.bucketAndObject());
        }
        return this.endsWith(other.toString());
    }

    @Override
    public boolean endsWith(String suffix) {
        return this.bucketAndObject().endsWith(suffix);
    }

    @Override
    public GcsPath normalize() {
        return this;
    }

    @Override
    public GcsPath resolve(Path other) {
        if (other instanceof GcsPath) {
            GcsPath path = (GcsPath)other;
            if (path.isAbsolute()) {
                return path;
            }
            return this.resolve(path.getObject());
        }
        return this.resolve(other.toString());
    }

    @Override
    public GcsPath resolve(String other) {
        if (this.bucket.isEmpty() && this.object.isEmpty()) {
            other = "gs://" + other;
        }
        if (other.startsWith("gs://")) {
            GcsPath path = GcsPath.fromUri(other);
            path.setFileSystem(this.getFileSystem());
            return path;
        }
        if (other.isEmpty()) {
            other = "/";
        }
        if (this.object.isEmpty()) {
            return new GcsPath(this.fs, this.bucket, other);
        }
        if (this.object.endsWith("/")) {
            return new GcsPath(this.fs, this.bucket, this.object + other);
        }
        return new GcsPath(this.fs, this.bucket, this.object + "/" + other);
    }

    @Override
    public Path resolveSibling(Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path resolveSibling(String other) {
        if (this.getNameCount() < 2) {
            throw new UnsupportedOperationException("Can't resolve the sibling of a root path: " + this);
        }
        GcsPath parent = this.getParent();
        return parent == null ? GcsPath.fromUri(other) : parent.resolve(other);
    }

    @Override
    public Path relativize(Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GcsPath toAbsolutePath() {
        return this;
    }

    @Override
    public GcsPath toRealPath(LinkOption ... options) throws IOException {
        return this;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        return new NameIterator(this.fs, !this.bucket.isEmpty(), this.bucketAndObject());
    }

    @Override
    public int compareTo(Path other) {
        if (!(other instanceof GcsPath)) {
            throw new ClassCastException();
        }
        GcsPath path = (GcsPath)other;
        int b = this.bucket.compareTo(path.bucket);
        if (b != 0) {
            return b;
        }
        Iterator<Path> left = this.iterator();
        Iterator<Path> right = path.iterator();
        while (left.hasNext() && right.hasNext()) {
            String rightStr;
            String leftStr = left.next().toString();
            int c = leftStr.compareTo(rightStr = right.next().toString());
            if (c == 0) continue;
            return c;
        }
        if (!left.hasNext() && !right.hasNext()) {
            return 0;
        }
        return left.hasNext() ? 1 : -1;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcsPath paths = (GcsPath)o;
        return this.bucket.equals(paths.bucket) && this.object.equals(paths.object);
    }

    @Override
    public int hashCode() {
        int result = this.bucket.hashCode();
        result = 31 * result + this.object.hashCode();
        return result;
    }

    @Override
    public String toString() {
        if (!this.isAbsolute()) {
            return this.object;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SCHEME).append("://");
        if (!this.bucket.isEmpty()) {
            sb.append(this.bucket).append('/');
        }
        sb.append(this.object);
        return sb.toString();
    }

    public String toResourceName() {
        StringBuilder sb = new StringBuilder();
        sb.append("storage.googleapis.com/");
        if (!this.bucket.isEmpty()) {
            sb.append(this.bucket).append('/');
        }
        sb.append(this.object);
        return sb.toString();
    }

    @Override
    public URI toUri() {
        try {
            return new URI(SCHEME, "//" + this.bucketAndObject(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to create URI for GCS path " + this);
        }
    }

    private String bucketAndObject() {
        if (this.bucket.isEmpty()) {
            return this.object;
        }
        return this.bucket + "/" + this.object;
    }

    private static class NameIterator
    implements Iterator<Path> {
        private final FileSystem fs;
        private boolean fullPath;
        private String name;

        NameIterator(FileSystem fs, boolean fullPath, String name) {
            this.fs = fs;
            this.fullPath = fullPath;
            this.name = name;
        }

        @Override
        public boolean hasNext() {
            return !Strings.isNullOrEmpty(this.name);
        }

        @Override
        public GcsPath next() {
            String component;
            int i = this.name.indexOf(47);
            if (i >= 0) {
                component = this.name.substring(0, i);
                this.name = this.name.substring(i + 1);
            } else {
                component = this.name;
                this.name = null;
            }
            if (this.fullPath) {
                this.fullPath = false;
                return new GcsPath(this.fs, component, "");
            }
            return new GcsPath(this.fs, "", component);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

