/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.splittabledofn;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.values.KV;
import org.joda.time.Instant;

public class WatermarkEstimators {
    public static <WatermarkEstimatorStateT> WatermarkAndStateObserver<WatermarkEstimatorStateT> threadSafe(WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
        if (watermarkEstimator instanceof TimestampObservingWatermarkEstimator) {
            return new ThreadSafeTimestampObservingWatermarkEstimator<WatermarkEstimatorStateT>(watermarkEstimator);
        }
        if (watermarkEstimator instanceof ManualWatermarkEstimator) {
            return new ThreadSafeManualWatermarkEstimator<WatermarkEstimatorStateT>(watermarkEstimator);
        }
        return new ThreadSafeWatermarkEstimator<WatermarkEstimatorStateT>(watermarkEstimator);
    }

    @ThreadSafe
    private static class ThreadSafeManualWatermarkEstimator<WatermarkEstimatorStateT>
    extends ThreadSafeWatermarkEstimator<WatermarkEstimatorStateT>
    implements ManualWatermarkEstimator<WatermarkEstimatorStateT> {
        ThreadSafeManualWatermarkEstimator(WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
            super(watermarkEstimator);
        }

        @Override
        public synchronized void setWatermark(Instant watermark) {
            ((ManualWatermarkEstimator)this.watermarkEstimator).setWatermark(watermark);
        }
    }

    @ThreadSafe
    private static class ThreadSafeTimestampObservingWatermarkEstimator<WatermarkEstimatorStateT>
    extends ThreadSafeWatermarkEstimator<WatermarkEstimatorStateT>
    implements TimestampObservingWatermarkEstimator<WatermarkEstimatorStateT> {
        ThreadSafeTimestampObservingWatermarkEstimator(WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
            super(watermarkEstimator);
        }

        @Override
        public synchronized void observeTimestamp(Instant timestamp) {
            ((TimestampObservingWatermarkEstimator)this.watermarkEstimator).observeTimestamp(timestamp);
        }
    }

    @ThreadSafe
    private static class ThreadSafeWatermarkEstimator<WatermarkEstimatorStateT>
    implements WatermarkAndStateObserver<WatermarkEstimatorStateT> {
        protected final WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator;

        ThreadSafeWatermarkEstimator(WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
            this.watermarkEstimator = watermarkEstimator;
        }

        @Override
        public synchronized Instant currentWatermark() {
            return this.watermarkEstimator.currentWatermark();
        }

        @Override
        public synchronized WatermarkEstimatorStateT getState() {
            return this.watermarkEstimator.getState();
        }

        @Override
        public synchronized KV<Instant, WatermarkEstimatorStateT> getWatermarkAndState() {
            return KV.of(this.watermarkEstimator.currentWatermark(), this.watermarkEstimator.getState());
        }
    }

    public static interface WatermarkAndStateObserver<WatermarkEstimatorStateT>
    extends WatermarkEstimator<WatermarkEstimatorStateT> {
        public KV<Instant, WatermarkEstimatorStateT> getWatermarkAndState();
    }
}

