/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.LocalFileSystem;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.TreeMultimap;

@Experimental(value=Experimental.Kind.FILESYSTEM)
public class FileSystems {
    public static final String DEFAULT_SCHEME = "file";
    private static final Pattern FILE_SCHEME_PATTERN = Pattern.compile("(?<scheme>[a-zA-Z][-a-zA-Z0-9+.]*):/.*");
    private static final Pattern GLOB_PATTERN = Pattern.compile("[*?{}]");
    private static final AtomicReference<Map<String, FileSystem>> SCHEME_TO_FILESYSTEM = new AtomicReference<ImmutableMap<String, LocalFileSystem>>(ImmutableMap.of("file", new LocalFileSystem()));

    public static boolean hasGlobWildcard(String spec) {
        return GLOB_PATTERN.matcher(spec).find();
    }

    public static List<MatchResult> match(List<String> specs) throws IOException {
        return FileSystems.getFileSystemInternal(FileSystems.getOnlyScheme(specs)).match(specs);
    }

    public static List<MatchResult> match(List<String> specs, EmptyMatchTreatment emptyMatchTreatment) throws IOException {
        List<MatchResult> matches = FileSystems.getFileSystemInternal(FileSystems.getOnlyScheme(specs)).match(specs);
        ArrayList<MatchResult> res = Lists.newArrayListWithExpectedSize(matches.size());
        for (int i = 0; i < matches.size(); ++i) {
            res.add(FileSystems.maybeAdjustEmptyMatchResult(specs.get(i), matches.get(i), emptyMatchTreatment));
        }
        return res;
    }

    public static MatchResult match(String spec) throws IOException {
        List<MatchResult> matches = FileSystems.match(Collections.singletonList(spec));
        Verify.verify(matches.size() == 1, "FileSystem implementation for %s did not return exactly one MatchResult: %s", (Object)spec, matches);
        return matches.get(0);
    }

    public static MatchResult match(String spec, EmptyMatchTreatment emptyMatchTreatment) throws IOException {
        MatchResult res = FileSystems.match(spec);
        return FileSystems.maybeAdjustEmptyMatchResult(spec, res, emptyMatchTreatment);
    }

    private static MatchResult maybeAdjustEmptyMatchResult(String spec, MatchResult res, EmptyMatchTreatment emptyMatchTreatment) throws IOException {
        if (res.status() == MatchResult.Status.NOT_FOUND || res.status() == MatchResult.Status.OK && res.metadata().isEmpty()) {
            boolean notFoundAllowed = emptyMatchTreatment == EmptyMatchTreatment.ALLOW || FileSystems.hasGlobWildcard(spec) && emptyMatchTreatment == EmptyMatchTreatment.ALLOW_IF_WILDCARD;
            return notFoundAllowed ? MatchResult.create(MatchResult.Status.OK, Collections.emptyList()) : MatchResult.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException("No files matched spec: " + spec));
        }
        return res;
    }

    public static MatchResult.Metadata matchSingleFileSpec(String spec) throws IOException {
        List<MatchResult> matches = FileSystems.match(Collections.singletonList(spec));
        MatchResult matchResult = Iterables.getOnlyElement(matches);
        if (matchResult.status() == MatchResult.Status.NOT_FOUND) {
            throw new FileNotFoundException(String.format("File spec %s not found", spec));
        }
        if (matchResult.status() != MatchResult.Status.OK) {
            throw new IOException(String.format("Error matching file spec %s: status %s", new Object[]{spec, matchResult.status()}));
        }
        List<MatchResult.Metadata> metadata = matchResult.metadata();
        if (metadata.size() != 1) {
            throw new IOException(String.format("Expecting spec %s to match exactly one file, but matched %s: %s", spec, metadata.size(), metadata));
        }
        return metadata.get(0);
    }

    public static List<MatchResult> matchResources(List<ResourceId> resourceIds) throws IOException {
        return FileSystems.match(FluentIterable.from(resourceIds).transform(ResourceId::toString).toList());
    }

    public static WritableByteChannel create(ResourceId resourceId, String mimeType) throws IOException {
        return FileSystems.create(resourceId, ((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType(mimeType)).build());
    }

    public static WritableByteChannel create(ResourceId resourceId, CreateOptions createOptions) throws IOException {
        return FileSystems.getFileSystemInternal(resourceId.getScheme()).create(resourceId, createOptions);
    }

    public static ReadableByteChannel open(ResourceId resourceId) throws IOException {
        return FileSystems.getFileSystemInternal(resourceId.getScheme()).open(resourceId);
    }

    public static void copy(List<ResourceId> srcResourceIds, List<ResourceId> destResourceIds, MoveOptions ... moveOptions) throws IOException {
        FileSystems.validateSrcDestLists(srcResourceIds, destResourceIds);
        if (srcResourceIds.isEmpty()) {
            return;
        }
        FileSystem fileSystem = FileSystems.getFileSystemInternal(srcResourceIds.iterator().next().getScheme());
        FilterResult filtered = FileSystems.filterFiles(fileSystem, srcResourceIds, destResourceIds, moveOptions);
        if (!filtered.resultSources.isEmpty()) {
            fileSystem.copy(filtered.resultSources, filtered.resultDestinations);
        }
    }

    public static void rename(List<ResourceId> srcResourceIds, List<ResourceId> destResourceIds, MoveOptions ... moveOptions) throws IOException {
        FileSystems.validateSrcDestLists(srcResourceIds, destResourceIds);
        if (srcResourceIds.isEmpty()) {
            return;
        }
        FileSystems.renameInternal(FileSystems.getFileSystemInternal(srcResourceIds.iterator().next().getScheme()), srcResourceIds, destResourceIds, moveOptions);
    }

    @VisibleForTesting
    static void renameInternal(FileSystem fileSystem, List<ResourceId> srcResourceIds, List<ResourceId> destResourceIds, MoveOptions ... moveOptions) throws IOException {
        block3: {
            try {
                fileSystem.rename(srcResourceIds, destResourceIds, moveOptions);
            }
            catch (UnsupportedOperationException e) {
                FilterResult filtered = FileSystems.filterFiles(fileSystem, srcResourceIds, destResourceIds, moveOptions);
                if (!filtered.resultSources.isEmpty()) {
                    fileSystem.rename(filtered.resultSources, filtered.resultDestinations, new MoveOptions[0]);
                }
                if (filtered.filteredExistingSrcs.isEmpty()) break block3;
                fileSystem.delete(filtered.filteredExistingSrcs);
            }
        }
    }

    public static void delete(Collection<ResourceId> resourceIds, MoveOptions ... moveOptions) throws IOException {
        if (resourceIds.isEmpty()) {
            return;
        }
        Collection<ResourceId> resourceIdsToDelete = Sets.newHashSet(moveOptions).contains(MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES) ? FluentIterable.from(FileSystems.matchResources(Lists.newArrayList(resourceIds))).filter(matchResult -> !matchResult.status().equals((Object)MatchResult.Status.NOT_FOUND)).transformAndConcat(new Function<MatchResult, Iterable<MatchResult.Metadata>>(){

            @Override
            @Nonnull
            @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
            public Iterable<MatchResult.Metadata> apply(@Nonnull MatchResult input) {
                try {
                    return Lists.newArrayList(input.metadata());
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to get metadata from MatchResult: %s.", input), e);
                }
            }
        }).transform(new Function<MatchResult.Metadata, ResourceId>(){

            @Override
            @Nonnull
            @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
            public ResourceId apply(@Nonnull MatchResult.Metadata input) {
                return input.resourceId();
            }
        }).toList() : resourceIds;
        if (resourceIdsToDelete.isEmpty()) {
            return;
        }
        FileSystems.getFileSystemInternal(resourceIdsToDelete.iterator().next().getScheme()).delete(resourceIdsToDelete);
    }

    private static FilterResult filterFiles(FileSystem fileSystem, List<ResourceId> srcResourceIds, List<ResourceId> destResourceIds, MoveOptions ... moveOptions) throws IOException {
        FilterResult result = new FilterResult();
        if (moveOptions.length == 0 || srcResourceIds.isEmpty()) {
            result.resultSources = srcResourceIds;
            result.resultDestinations = destResourceIds;
            return result;
        }
        HashSet<MoveOptions> moveOptionSet = Sets.newHashSet(moveOptions);
        boolean ignoreMissingSrc = moveOptionSet.contains(MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
        boolean skipExistingDest = moveOptionSet.contains(MoveOptions.StandardMoveOptions.SKIP_IF_DESTINATION_EXISTS);
        int size = srcResourceIds.size();
        ArrayList<ResourceId> matchResources = new ArrayList<ResourceId>();
        if (ignoreMissingSrc) {
            matchResources.addAll(srcResourceIds);
        }
        if (skipExistingDest) {
            matchResources.addAll(destResourceIds);
        }
        List<MatchResult> matchResults = fileSystem.match(FluentIterable.from(matchResources).transform(ResourceId::toString).toList());
        List<MatchResult> matchSrcResults = ignoreMissingSrc ? matchResults.subList(0, size) : null;
        List<MatchResult> matchDestResults = skipExistingDest ? matchResults.subList(matchResults.size() - size, matchResults.size()) : null;
        for (int i = 0; i < size; ++i) {
            if (matchSrcResults != null && matchSrcResults.get(i).status().equals((Object)MatchResult.Status.NOT_FOUND)) continue;
            if (matchDestResults != null && matchDestResults.get(i).status().equals((Object)MatchResult.Status.OK) && FileSystems.checksumMatch(matchDestResults.get(i).metadata().get(0), matchSrcResults.get(i).metadata().get(0))) {
                result.filteredExistingSrcs.add(srcResourceIds.get(i));
                continue;
            }
            result.resultSources.add(srcResourceIds.get(i));
            result.resultDestinations.add(destResourceIds.get(i));
        }
        return result;
    }

    private static boolean checksumMatch(MatchResult.Metadata first, MatchResult.Metadata second) {
        return first.checksum() != null && first.checksum().equals(second.checksum());
    }

    private static void validateSrcDestLists(List<ResourceId> srcResourceIds, List<ResourceId> destResourceIds) {
        Preconditions.checkArgument(srcResourceIds.size() == destResourceIds.size(), "Number of source resource ids %s must equal number of destination resource ids %s", srcResourceIds.size(), destResourceIds.size());
        if (srcResourceIds.isEmpty()) {
            return;
        }
        ImmutableSet schemes = FluentIterable.from(srcResourceIds).append((Iterable<ResourceId>)destResourceIds).transform(ResourceId::getScheme).toSet();
        Preconditions.checkArgument(schemes.size() == 1, String.format("Expect srcResourceIds and destResourceIds have the same scheme, but received %s.", Joiner.on(", ").join(schemes)));
    }

    private static String getOnlyScheme(List<String> specs) {
        Preconditions.checkArgument(!specs.isEmpty(), "Expect specs are not empty.");
        ImmutableSet schemes = FluentIterable.from(specs).transform(FileSystems::parseScheme).toSet();
        return (String)Iterables.getOnlyElement(schemes);
    }

    private static String parseScheme(String spec) {
        Matcher matcher = FILE_SCHEME_PATTERN.matcher(spec);
        if (!matcher.matches()) {
            return DEFAULT_SCHEME;
        }
        return matcher.group("scheme").toLowerCase();
    }

    @VisibleForTesting
    static FileSystem getFileSystemInternal(String scheme) {
        String lowerCaseScheme = scheme.toLowerCase();
        Map<String, FileSystem> schemeToFileSystem = SCHEME_TO_FILESYSTEM.get();
        FileSystem rval = schemeToFileSystem.get(lowerCaseScheme);
        if (rval == null) {
            throw new IllegalArgumentException("No filesystem found for scheme " + scheme);
        }
        return rval;
    }

    @Internal
    public static void setDefaultPipelineOptions(PipelineOptions options) {
        Preconditions.checkNotNull(options, "options");
        TreeSet<Object> registrars = Sets.newTreeSet(ReflectHelpers.ObjectsClassComparator.INSTANCE);
        registrars.addAll(Lists.newArrayList(ServiceLoader.load(FileSystemRegistrar.class, ReflectHelpers.findClassLoader())));
        SCHEME_TO_FILESYSTEM.set(FileSystems.verifySchemesAreUnique(options, registrars));
    }

    @VisibleForTesting
    static Map<String, FileSystem> verifySchemesAreUnique(PipelineOptions options, Set<FileSystemRegistrar> registrars) {
        TreeMultimap fileSystemsBySchemes = TreeMultimap.create(Ordering.natural(), Ordering.arbitrary());
        for (FileSystemRegistrar fileSystemRegistrar : registrars) {
            for (FileSystem<?> fileSystem : fileSystemRegistrar.fromOptions(options)) {
                fileSystemsBySchemes.put(fileSystem.getScheme(), (Object)fileSystem);
            }
        }
        for (Map.Entry entry : fileSystemsBySchemes.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            String conflictingFileSystems = Joiner.on(", ").join(FluentIterable.from((Iterable)entry.getValue()).transform(input -> input.getClass().getName()).toSortedList(Ordering.natural()));
            throw new IllegalStateException(String.format("Scheme: [%s] has conflicting filesystems: [%s]", entry.getKey(), conflictingFileSystems));
        }
        ImmutableMap.Builder<String, FileSystem> schemeToFileSystem = ImmutableMap.builder();
        for (Map.Entry entry : fileSystemsBySchemes.entries()) {
            schemeToFileSystem.put((String)entry.getKey(), (FileSystem)entry.getValue());
        }
        return schemeToFileSystem.build();
    }

    public static ResourceId matchNewResource(String singleResourceSpec, boolean isDirectory) {
        return FileSystems.getFileSystemInternal(FileSystems.parseScheme(singleResourceSpec)).matchNewResource(singleResourceSpec, isDirectory);
    }

    private static class FilterResult {
        public List<ResourceId> resultSources = new ArrayList<ResourceId>();
        public List<ResourceId> resultDestinations = new ArrayList<ResourceId>();
        public List<ResourceId> filteredExistingSrcs = new ArrayList<ResourceId>();

        private FilterResult() {
        }
    }
}

